/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.security.util;

import com.yto.monitor.adapter.security.AlipayApiException;
import com.yto.monitor.adapter.security.util.AlipayHashMap;
import com.yto.monitor.adapter.security.util.RequestParametersHolder;
import com.yto.monitor.adapter.security.util.SignSourceData;
import com.yto.monitor.adapter.security.util.StringUtils;
import com.yto.monitor.adapter.security.util.asymmetric.AsymmetricManager;
import com.yto.monitor.adapter.security.util.asymmetric.RSAEncryptor;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlipaySignature {
    public static String sign(String content, String privateKey, String charset, String signType) throws AlipayApiException {
        return AsymmetricManager.getByName((String)signType).sign(content, charset, privateKey);
    }

    public static String sign(Map<String, String> params, String privateKey, String charset, String signType) throws AlipayApiException {
        String signContent = AlipaySignature.getSignContent(params);
        return AsymmetricManager.getByName((String)signType).sign(signContent, charset, privateKey);
    }

    public static boolean verifyV1(Map<String, String> params, String publicKey, String charset, String signType) throws AlipayApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV1(params);
        return AsymmetricManager.getByName((String)signType).verify(content, charset, publicKey, sign);
    }

    public static boolean verifyV2(Map<String, String> params, String publicKey, String charset, String signType) throws AlipayApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV2(params);
        return AsymmetricManager.getByName((String)signType).verify(content, charset, publicKey, sign);
    }

    public static boolean verify(String content, String sign, String publicKey, String charset, String signType) throws AlipayApiException {
        return AsymmetricManager.getByName((String)signType).verify(content, charset, publicKey, sign);
    }

    public static String encrypt(String content, String publicKey, String charset, String signType) throws AlipayApiException {
        return AsymmetricManager.getByName((String)signType).encrypt(content, charset, publicKey);
    }

    public static String decrypt(String content, String privateKey, String charset, String signType) throws AlipayApiException {
        return AsymmetricManager.getByName((String)signType).decrypt(content, charset, privateKey);
    }

    public static String encryptAndSign(String bizContent, String alipayPublicKey, String cusPrivateKey, String charset, boolean isEncrypt, boolean isSign, String signType) throws AlipayApiException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((String)charset)) {
            charset = "GBK";
        }
        sb.append("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
        if (isEncrypt) {
            sb.append("<alipay>");
            String encrypted = AlipaySignature.encrypt((String)bizContent, (String)alipayPublicKey, (String)charset, (String)signType);
            sb.append("<response>" + encrypted + "</response>");
            sb.append("<encryption_type>RSA</encryption_type>");
            if (isSign) {
                String sign = AlipaySignature.sign((String)encrypted, (String)cusPrivateKey, (String)charset, (String)signType);
                sb.append("<sign>" + sign + "</sign>");
                sb.append("<sign_type>RSA</sign_type>");
            }
            sb.append("</alipay>");
        } else if (isSign) {
            sb.append("<alipay>");
            sb.append("<response>" + bizContent + "</response>");
            String sign = AlipaySignature.sign((String)bizContent, (String)cusPrivateKey, (String)charset, (String)signType);
            sb.append("<sign>" + sign + "</sign>");
            sb.append("<sign_type>RSA</sign_type>");
            sb.append("</alipay>");
        } else {
            sb.append(bizContent);
        }
        return sb.toString();
    }

    public static String checkSignAndDecrypt(Map<String, String> params, String alipayPublicKey, String cusPrivateKey, boolean isCheckSign, boolean isDecrypt, String signType) throws AlipayApiException {
        String charset = params.get("charset");
        String bizContent = params.get("biz_content");
        if (isCheckSign && !AlipaySignature.verifyV2(params, (String)alipayPublicKey, (String)charset, (String)signType)) {
            throw new AlipayApiException("rsaCheck failure:rsaParams=" + params);
        }
        if (isDecrypt) {
            return AlipaySignature.decrypt((String)bizContent, (String)cusPrivateKey, (String)charset, (String)signType);
        }
        return bizContent;
    }

    public static String getSignatureContent(RequestParametersHolder requestHolder) {
        return AlipaySignature.getSignContent((Map)AlipaySignature.getSortedMap((RequestParametersHolder)requestHolder));
    }

    public static Map<String, String> getSortedMap(RequestParametersHolder requestHolder) {
        AlipayHashMap protocalOptParams;
        AlipayHashMap protocalMustParams;
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        AlipayHashMap appParams = requestHolder.getApplicationParams();
        if (appParams != null && appParams.size() > 0) {
            sortedParams.putAll((Map<String, String>)appParams);
        }
        if ((protocalMustParams = requestHolder.getProtocalMustParams()) != null && protocalMustParams.size() > 0) {
            sortedParams.putAll((Map<String, String>)protocalMustParams);
        }
        if ((protocalOptParams = requestHolder.getProtocalOptParams()) != null && protocalOptParams.size() > 0) {
            sortedParams.putAll((Map<String, String>)protocalOptParams);
        }
        return sortedParams;
    }

    public static String getSignContent(Map<String, String> sortedParams) {
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        int index = 0;
        for (String key : keys) {
            String value;
            if (!StringUtils.areNotEmpty((String[])new String[]{key, value = sortedParams.get(key)})) continue;
            content.append(index == 0 ? "" : "&").append(key).append("=").append(value);
            ++index;
        }
        return content.toString();
    }

    public static SignSourceData extractSignContent(String str, int begin) {
        if (str == null) {
            return null;
        }
        int beginIndex = AlipaySignature.extractBeginPosition((String)str, (int)begin);
        if (beginIndex >= str.length()) {
            return null;
        }
        int endIndex = AlipaySignature.extractEndPosition((String)str, (int)beginIndex);
        return new SignSourceData(str.substring(beginIndex, endIndex), beginIndex, endIndex);
    }

    private static int extractBeginPosition(String responseString, int begin) {
        int beginPosition;
        for (beginPosition = begin; beginPosition < responseString.length() && responseString.charAt(beginPosition) != '{' && responseString.charAt(beginPosition) != '\"'; ++beginPosition) {
        }
        return beginPosition;
    }

    private static int extractEndPosition(String responseString, int beginPosition) {
        if (responseString.charAt(beginPosition) == '{') {
            return AlipaySignature.extractJsonObjectEndPosition((String)responseString, (int)beginPosition);
        }
        return AlipaySignature.extractJsonBase64ValueEndPosition((String)responseString, (int)beginPosition);
    }

    private static int extractJsonBase64ValueEndPosition(String responseString, int beginPosition) {
        for (int index = beginPosition; index < responseString.length(); ++index) {
            if (responseString.charAt(index) != '\"' || index == beginPosition) continue;
            return index + 1;
        }
        return responseString.length();
    }

    private static int extractJsonObjectEndPosition(String responseString, int beginPosition) {
        LinkedList<String> braces = new LinkedList<String>();
        boolean inQuotes = false;
        int consecutiveEscapeCount = 0;
        for (int index = beginPosition; index < responseString.length(); ++index) {
            char currentChar = responseString.charAt(index);
            if (currentChar == '\"' && consecutiveEscapeCount % 2 == 0) {
                inQuotes = !inQuotes;
            } else if (currentChar == '{' && !inQuotes) {
                braces.push("{");
            } else if (currentChar == '}' && !inQuotes) {
                braces.pop();
                if (braces.isEmpty()) {
                    return index + 1;
                }
            }
            if (currentChar == '\\') {
                ++consecutiveEscapeCount;
                continue;
            }
            consecutiveEscapeCount = 0;
        }
        return responseString.length();
    }

    public static String rsaSign(String content, String privateKey, String charset, String signType) throws AlipayApiException {
        return AsymmetricManager.getByName((String)signType).sign(content, charset, privateKey);
    }

    public static String rsa256Sign(String content, String privateKey, String charset) throws AlipayApiException {
        return AsymmetricManager.getByName((String)"RSA2").sign(content, charset, privateKey);
    }

    public static String rsaSign(String content, String privateKey, String charset) throws AlipayApiException {
        return AsymmetricManager.getByName((String)"RSA").sign(content, charset, privateKey);
    }

    public static String rsaSign(Map<String, String> params, String privateKey, String charset) throws AlipayApiException {
        String signContent = AlipaySignature.getSignContent(params);
        return AlipaySignature.rsaSign((String)signContent, (String)privateKey, (String)charset);
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        return RSAEncryptor.getPrivateKeyFromPKCS8((String)algorithm, (InputStream)ins);
    }

    public static String getSignCheckContentV1(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        params.remove("sign_type");
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append((i == 0 ? "" : "&") + key + "=" + value);
        }
        return content.toString();
    }

    public static String getSignCheckContentV2(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append(i == 0 ? "" : "&").append(key).append("=").append(value);
        }
        return content.toString();
    }

    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset) throws AlipayApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV1(params);
        return AlipaySignature.rsaCheckContent((String)content, (String)sign, (String)publicKey, (String)charset);
    }

    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset, String signType) throws AlipayApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV1(params);
        return AlipaySignature.rsaCheck((String)content, (String)sign, (String)publicKey, (String)charset, (String)signType);
    }

    public static boolean rsaCheckV2(Map<String, String> params, String publicKey, String charset) throws AlipayApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV2(params);
        return AlipaySignature.rsaCheckContent((String)content, (String)sign, (String)publicKey, (String)charset);
    }

    public static boolean rsaCheckV2(Map<String, String> params, String publicKey, String charset, String signType) throws AlipayApiException {
        String sign = params.get("sign");
        String content = AlipaySignature.getSignCheckContentV2(params);
        return AlipaySignature.rsaCheck((String)content, (String)sign, (String)publicKey, (String)charset, (String)signType);
    }

    public static boolean rsaCheck(String content, String sign, String publicKey, String charset, String signType) throws AlipayApiException {
        return AsymmetricManager.getByName((String)signType).verify(content, charset, publicKey, sign);
    }

    public static boolean rsa256CheckContent(String content, String sign, String publicKey, String charset) throws AlipayApiException {
        return AsymmetricManager.getByName((String)"RSA2").verify(content, charset, publicKey, sign);
    }

    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) throws AlipayApiException {
        return AsymmetricManager.getByName((String)"RSA").verify(content, charset, publicKey, sign);
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        return RSAEncryptor.getPublicKeyFromX509((String)algorithm, (InputStream)ins);
    }

    public static String checkSignAndDecrypt(Map<String, String> params, String alipayPublicKey, String cusPrivateKey, boolean isCheckSign, boolean isDecrypt) throws AlipayApiException {
        String charset = params.get("charset");
        String bizContent = params.get("biz_content");
        if (isCheckSign && !AlipaySignature.rsaCheckV2(params, (String)alipayPublicKey, (String)charset)) {
            throw new AlipayApiException("rsaCheck failure:rsaParams=" + params);
        }
        if (isDecrypt) {
            return AlipaySignature.rsaDecrypt((String)bizContent, (String)cusPrivateKey, (String)charset);
        }
        return bizContent;
    }

    public static String encryptAndSign(String bizContent, String alipayPublicKey, String cusPrivateKey, String charset, boolean isEncrypt, boolean isSign) throws AlipayApiException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((String)charset)) {
            charset = "GBK";
        }
        sb.append("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>");
        if (isEncrypt) {
            sb.append("<alipay>");
            String encrypted = AlipaySignature.rsaEncrypt((String)bizContent, (String)alipayPublicKey, (String)charset);
            sb.append("<response>" + encrypted + "</response>");
            sb.append("<encryption_type>RSA</encryption_type>");
            if (isSign) {
                String sign = AlipaySignature.rsaSign((String)encrypted, (String)cusPrivateKey, (String)charset);
                sb.append("<sign>" + sign + "</sign>");
                sb.append("<sign_type>RSA</sign_type>");
            }
            sb.append("</alipay>");
        } else if (isSign) {
            sb.append("<alipay>");
            sb.append("<response>" + bizContent + "</response>");
            String sign = AlipaySignature.rsaSign((String)bizContent, (String)cusPrivateKey, (String)charset);
            sb.append("<sign>" + sign + "</sign>");
            sb.append("<sign_type>RSA</sign_type>");
            sb.append("</alipay>");
        } else {
            sb.append(bizContent);
        }
        return sb.toString();
    }

    public static String rsaEncrypt(String content, String publicKey, String charset) throws AlipayApiException {
        return AsymmetricManager.getByName((String)"RSA").encrypt(content, charset, publicKey);
    }

    public static String rsaDecrypt(String content, String privateKey, String charset) throws AlipayApiException {
        return AsymmetricManager.getByName((String)"RSA").decrypt(content, charset, privateKey);
    }
}

