/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.security.util.asymmetric;

import com.yto.monitor.adapter.security.util.StreamUtil;
import com.yto.monitor.adapter.security.util.asymmetric.BaseAsymmetricEncryptor;
import com.yto.monitor.adapter.security.util.codec.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RSAEncryptor
extends BaseAsymmetricEncryptor {
    private static final int MAX_ENCRYPT_BLOCK_SIZE = 117;
    private static final int MAX_DECRYPT_BLOCK_SIZE = 128;

    protected String getSignAlgorithm() {
        return "SHA1WithRSA";
    }

    protected String getAsymmetricType() {
        return "RSA";
    }

    protected int getMaxDecryptBlockSize() {
        return 128;
    }

    protected int getMaxEncryptBlockSize() {
        return 117;
    }

    protected String doDecrypt(String cipherTextBase64, String charset, String privateKey) throws Exception {
        int maxDecrypt = this.getMaxDecryptBlockSize();
        PrivateKey priKey = RSAEncryptor.getPrivateKeyFromPKCS8((String)"RSA", (InputStream)new ByteArrayInputStream(privateKey.getBytes()));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, priKey);
        byte[] encryptedData = StringUtils.isEmpty((CharSequence)charset) ? Base64.decodeBase64((byte[])cipherTextBase64.getBytes()) : Base64.decodeBase64((byte[])cipherTextBase64.getBytes(charset));
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > maxDecrypt ? cipher.doFinal(encryptedData, offSet, maxDecrypt) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * maxDecrypt;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return StringUtils.isEmpty((CharSequence)charset) ? new String(decryptedData) : new String(decryptedData, charset);
    }

    protected String doEncrypt(String plainText, String charset, String publicKey) throws Exception {
        int maxEncrypt = this.getMaxEncryptBlockSize();
        PublicKey pubKey = RSAEncryptor.getPublicKeyFromX509((String)"RSA", (InputStream)new ByteArrayInputStream(publicKey.getBytes()));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, pubKey);
        byte[] data = StringUtils.isEmpty((CharSequence)charset) ? plainText.getBytes() : plainText.getBytes(charset);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > maxEncrypt ? cipher.doFinal(data, offSet, maxEncrypt) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * maxEncrypt;
        }
        byte[] encryptedData = Base64.encodeBase64((byte[])out.toByteArray());
        out.close();
        return StringUtils.isEmpty((CharSequence)charset) ? new String(encryptedData) : new String(encryptedData, charset);
    }

    protected String doSign(String content, String charset, String privateKey) throws Exception {
        PrivateKey priKey = RSAEncryptor.getPrivateKeyFromPKCS8((String)"RSA", (InputStream)new ByteArrayInputStream(privateKey.getBytes()));
        Signature signature = Signature.getInstance(this.getSignAlgorithm());
        signature.initSign(priKey);
        if (StringUtils.isEmpty((CharSequence)charset)) {
            signature.update(content.getBytes());
        } else {
            signature.update(content.getBytes(charset));
        }
        byte[] signed = signature.sign();
        return new String(Base64.encodeBase64((byte[])signed));
    }

    protected boolean doVerify(String content, String charset, String publicKey, String sign) throws Exception {
        PublicKey pubKey = RSAEncryptor.getPublicKeyFromX509((String)"RSA", (InputStream)new ByteArrayInputStream(publicKey.getBytes()));
        Signature signature = Signature.getInstance(this.getSignAlgorithm());
        signature.initVerify(pubKey);
        if (StringUtils.isEmpty((CharSequence)charset)) {
            signature.update(content.getBytes());
        } else {
            signature.update(content.getBytes(charset));
        }
        return signature.verify(Base64.decodeBase64((byte[])sign.getBytes()));
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins == null || StringUtils.isEmpty((CharSequence)algorithm)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = StreamUtil.readText((InputStream)ins).getBytes();
        encodedKey = Base64.decodeBase64((byte[])encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io((Reader)new InputStreamReader(ins), (Writer)writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64((byte[])encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }
}

