/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.utils;

import com.yto.monitor.adapter.entity.DispatchProcessEntity;
import com.yto.monitor.adapter.utils.CommonUtil;
import com.yto.monitor.common.entity.interfaces.IBaseResponse;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdapterUtils {
    private static final Logger logger = LoggerFactory.getLogger(AdapterUtils.class);

    public static <T extends IBaseResponse> void prepareDataAndSend2Server(DispatchProcessEntity entity, Function<Integer, List<?>> dbQueryFunction, BiConsumer<Integer, List<?>> dbUpdateConsumer, Class<T> responseClass) {
        if (!CollectionUtils.isEmpty((Collection)entity.getDataList())) {
            AdapterUtils.handleDataByPage((DispatchProcessEntity)entity, dbUpdateConsumer, responseClass);
            return;
        }
        int tryCount = 0;
        boolean continueFlag = true;
        do {
            try {
                List<?> dataList = dbQueryFunction.apply(entity.getTablePageSize());
                if (CollectionUtils.isEmpty(dataList)) {
                    return;
                }
                entity.setDataList(dataList);
                AdapterUtils.handleDataByPage((DispatchProcessEntity)entity, dbUpdateConsumer, responseClass);
                if (dataList.size() < entity.getTablePageSize() || entity.getTrySendCount() >= entity.getMaxSendCount() || entity.isTimeoutFlag()) {
                    continueFlag = false;
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("\u7ebf\u7a0b\u88ab\u672a\u77e5\u539f\u56e0\u4e2d\u65ad ", (Object)e.getMessage());
            }
            catch (Exception e) {
                continueFlag = ++tryCount <= entity.getMaxDbTryCount();
                logger.info("\u67e5\u8be2" + entity.getDescMsg() + "\u6570\u636e\u65f6\uff0c\u6570\u636e\u5e93\u62a5\u9519\u7b2c" + tryCount + "\u6b21");
            }
        } while (continueFlag);
    }

    public static <T extends IBaseResponse> void handleDataByPage(DispatchProcessEntity entity, BiConsumer<Integer, List<?>> dbUpdateConsumer, Class<T> responseClass) {
        List dataList = entity.getDataList();
        int totalCount = dataList.size();
        int pageSize = entity.getSendPageSize();
        int start = 0;
        int end = 0;
        int pageIndex = 0;
        for (int pageCount = (totalCount - 1) / pageSize + 1; pageCount > 0; --pageCount) {
            if ((System.currentTimeMillis() - entity.getStartTime()) / 60000L >= (long)entity.getTimeout()) {
                logger.info(entity.getDescMsg() + "\u6267\u884c\u8d85\u65f6");
                entity.setTimeoutFlag(true);
                return;
            }
            start = pageSize * pageIndex;
            end = pageCount > 1 ? start + pageSize : totalCount;
            entity.setDataList(dataList.subList(start, end));
            AdapterUtils.sendDataToServer((DispatchProcessEntity)entity, dbUpdateConsumer, responseClass);
            if (entity.getTrySendCount() >= entity.getMaxSendCount()) {
                logger.info("\u63a8\u9001" + entity.getDescMsg() + "\u5df2\u7ecf\u8d85\u51fa\u4e86\u6700\u5927\u5931\u8d25\u6b21\u6570\uff0c\u5f53\u524d\u63a8\u9001\u7ed3\u675f");
                return;
            }
            ++pageIndex;
        }
    }

    public static <T extends IBaseResponse> void sendDataToServer(DispatchProcessEntity entity, BiConsumer<Integer, List<?>> dbUpdateConsumer, Class<T> responseClass) {
        IBaseResponse result;
        logger.info("\u51c6\u5907\u63a8\u9001" + entity.getDescMsg() + "\u6570\u636e\u5230\u76d1\u63a7\u603b\u90e8");
        String response = CommonUtil.sendRequest((RestTemplate)entity.getRestTemplate(), (String)entity.getUrl(), (Object)entity.getDataList(), null);
        if (response != null && (result = (IBaseResponse)CommonUtil.parseJsonToPojo((String)response, responseClass)) != null && result.checkResultOk()) {
            logger.info(entity.getDescMsg() + "\u6570\u636e\u63a8\u9001\u6210\u529f");
            dbUpdateConsumer.accept(1, entity.getDataList());
            return;
        }
        entity.setTrySendCount(entity.getTrySendCount() + 1);
        logger.info("\u63a8\u9001" + entity.getDescMsg() + "\u6570\u636e\u5931\u8d25\u7b2c" + entity.getTrySendCount() + "\u6b21, \u6536\u5230\u670d\u52a1\u7aef\u54cd\u5e94\uff1a" + response);
        dbUpdateConsumer.accept(2, entity.getDataList());
    }
}

