/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.yto.monitor.adapter.utils.SignUtil;
import com.yto.monitor.common.component.SafeProperties;
import com.yto.monitor.common.entity.operationStatistic.OperationLogData;
import com.yto.monitor.common.entity.operationStatistic.OperationStatisticEntity;
import com.yto.monitor.common.entity.operationStatistic.OperationTotalData;
import com.yto.monitor.common.entity.operationStatistic.OperationWeightData;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.util.Base64Utils;
import com.yto.monitor.common.util.GoogleJsonUtil;
import com.yto.monitor.common.util.MD5Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommonUtil {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtil.class);
    private static final String HEADER = "Accept";
    private static final String TIME_FORMAT_DATE_SHORT = "yyyyMMdd";

    public static Gson getJsonHandler() {
        return GoogleJsonUtil.INSTANCE;
    }

    public static String toJsonString(Object obj) {
        return CommonUtil.getJsonHandler().toJson(obj);
    }

    public static JsonObject toJsonObject(String json) {
        return new JsonParser().parse(json).getAsJsonObject();
    }

    public static <T> T convertJsonToBean(String jsonStr, TypeToken<T> t) {
        Object resultObject = null;
        try {
            resultObject = CommonUtil.getJsonHandler().fromJson(jsonStr, t.getType());
        }
        catch (JsonSyntaxException e) {
            logger.error("\u8bf7\u6c42\u6570\u636e\u8f6c\u5bf9\u8c61\u5931\u8d25...", (Throwable)e);
        }
        return (T)resultObject;
    }

    public static String encryptBeanToSignature(Object obj, String charset) {
        String jsonBean = GoogleJsonUtil.toJson((Object)obj);
        return CommonUtil.encryptJsonToSignature((String)jsonBean, (String)charset);
    }

    public static String encryptJsonToSignature(String jsonStr, String charset) {
        String encryptSignature = null;
        try {
            int strLen = jsonStr.getBytes(charset).length;
            String srcLen = String.format("%08d", strLen);
            String decryptSignature = srcLen + jsonStr;
            encryptSignature = MD5Util.encode((String)decryptSignature, (String)charset);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("\u52a0\u5bc6\u7b7e\u540d\u65f6\u51fa\u9519(\u65e0\u6b64\u7b97\u6cd5)");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u52a0\u5bc6\u7b7e\u540d\u65f6\u51fa\u9519(\u4e0d\u652f\u6301\u7684\u7f16\u7801\u683c\u5f0f)");
        }
        return encryptSignature;
    }

    public static String processResponse(ResponseEntity<String> response) {
        if (response == null) {
            return null;
        }
        if (response.getStatusCode().value() == 200) {
            if (response.getBody() == null) {
                logger.error("\u54cd\u5e94\u6b63\u6587\u4e3a\u7a7a\uff0c\u670d\u52a1\u7aef\u7a0b\u5e8f\u51fa\u9519");
            }
        } else {
            logger.error("\u8bf7\u6c42\u5931\u8d25\uff0c\u54cd\u5e94\u72b6\u6001\u7801\u4e3a\uff1a" + response.getStatusCode().value());
        }
        return (String)response.getBody();
    }

    public static <T> T parseJsonToPojo(String json, Class<T> clz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        Object type = null;
        try {
            type = CommonUtil.getJsonHandler().fromJson(json, clz);
        }
        catch (JsonSyntaxException e) {
            logger.error("Json\u683c\u5f0f\u4e0ePOJO\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5");
        }
        return (T)type;
    }

    public static RestTemplate getRestTemplate(int timeout) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(timeout);
        requestFactory.setReadTimeout(timeout);
        RestTemplate restTemp = new RestTemplate();
        restTemp.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        restTemp.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemp;
    }

    public static <T> String sendRequest(RestTemplate restTemplate, String url, T msgBody, Map<String, Object> urlRequestParam) {
        return CommonUtil.sendRequest((RestTemplate)restTemplate, (String)url, msgBody, urlRequestParam, (HttpHeaders)new HttpHeaders());
    }

    public static <T> String sendRequest(RestTemplate restTemplate, String url, T msgBody, Map<String, Object> urlRequestParam, HttpHeaders headers) {
        ResponseEntity response = null;
        if (headers == null) {
            headers = new HttpHeaders();
        }
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        }
        if (headers.get((Object)"Accept") == null) {
            headers.add("Accept", "application/json;charset=UTF-8");
        }
        if (url.contains("/Yto_ManageWeb") || url.contains("/Yto_AutomaticMonitor")) {
            SignUtil.sign4RestTemplate((HttpHeaders)headers);
        }
        HttpEntity httpEntity = new HttpEntity(msgBody, (MultiValueMap)headers);
        try {
            response = restTemplate.postForEntity(CommonUtil.spliceUrl((String)url, urlRequestParam), (Object)httpEntity, String.class, new Object[0]);
            return CommonUtil.processResponse((ResponseEntity)response);
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                logger.error("\u672a\u6388\u6743");
                HttpBaseResponse httpBaseResponse = new HttpBaseResponse();
                httpBaseResponse.setRespCode("401");
                httpBaseResponse.setRespMessage("\u672a\u6388\u6743");
                httpBaseResponse.setData(null);
                return GoogleJsonUtil.toJson((Object)httpBaseResponse);
            }
            logger.error("\u8bf7\u6c42\uff1a" + url, (Throwable)ex);
        }
        catch (RestClientException e) {
            logger.error("\u8bf7\u6c42\uff1a" + url + ",\u8fde\u63a5\u5931\u8d25\uff1a{}", (Throwable)e);
            HttpBaseResponse httpBaseResponse = new HttpBaseResponse();
            httpBaseResponse.setRespCode("500");
            httpBaseResponse.setRespMessage(e.getLocalizedMessage());
            httpBaseResponse.setData(null);
            return GoogleJsonUtil.toJson((Object)httpBaseResponse);
        }
        return null;
    }

    public static <O> O sendGetRequest(RestTemplate restTemplate, String url, Map<String, Object> urlRequestParam, HttpHeaders headers, ParameterizedTypeReference<O> responseType) throws Exception {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        }
        if (headers.get((Object)"Accept") == null) {
            headers.add("Accept", "application/json;charset=UTF-8");
        }
        if (url.contains("/Yto_ManageWeb") || url.contains("/Yto_AutomaticMonitor")) {
            SignUtil.sign4RestTemplate((HttpHeaders)headers);
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity exchange = restTemplate.exchange(CommonUtil.spliceUrl((String)url, urlRequestParam), HttpMethod.GET, httpEntity, responseType, new Object[0]);
        return (O)exchange.getBody();
    }

    public static <O> O postForm(RestTemplate template, String url, LinkedMultiValueMap<String, Object> formData, Map<String, Object> urlRequestParam, HttpHeaders headers, ParameterizedTypeReference<O> responseType) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        if (url.contains("/Yto_ManageWeb")) {
            SignUtil.sign4RestTemplate((HttpHeaders)headers);
        }
        HttpEntity httpEntity = new HttpEntity(formData, (MultiValueMap)headers);
        ResponseEntity exchange = template.exchange(CommonUtil.spliceUrl((String)url, urlRequestParam), HttpMethod.POST, httpEntity, responseType, new Object[0]);
        return (O)exchange.getBody();
    }

    public static <T> String sendRequestNoCatch(RestTemplate restTemplate, String url, T msgBody, Map<String, Object> urlRequestParam, HttpHeaders headers) throws Exception {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        }
        if (headers.get((Object)"Accept") == null) {
            headers.add("Accept", "application/json;charset=UTF-8");
        }
        if (url.contains("/Yto_ManageWeb") || url.contains("/Yto_AutomaticMonitor")) {
            SignUtil.sign4RestTemplate((HttpHeaders)headers);
        }
        HttpEntity httpEntity = new HttpEntity(msgBody, (MultiValueMap)headers);
        ResponseEntity response = restTemplate.postForEntity(CommonUtil.spliceUrl((String)url, urlRequestParam), (Object)httpEntity, String.class, new Object[0]);
        return CommonUtil.processResponse((ResponseEntity)response);
    }

    public static <T, O> T sendRequestNoCatch(RestTemplate restTemplate, String url, O msgBody, Map<String, Object> urlRequestParam, HttpHeaders headers, ParameterizedTypeReference<T> responseType) throws Exception {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        }
        if (headers.get((Object)"Accept") == null) {
            headers.add("Accept", "application/json;charset=UTF-8");
        }
        if (url.contains("/Yto_ManageWeb") || url.contains("/Yto_AutomaticMonitor")) {
            SignUtil.sign4RestTemplate((HttpHeaders)headers);
        }
        HttpEntity httpEntity = new HttpEntity(msgBody, (MultiValueMap)headers);
        ResponseEntity exchange = restTemplate.exchange(CommonUtil.spliceUrl((String)url, urlRequestParam), HttpMethod.POST, httpEntity, responseType, new Object[0]);
        return (T)exchange.getBody();
    }

    public static String spliceUrl(String url, Map<String, Object> urlRequestParam) {
        if (CollectionUtils.isEmpty(urlRequestParam)) {
            return url;
        }
        StringBuffer sb = new StringBuffer("?");
        for (Map.Entry<String, Object> map : urlRequestParam.entrySet()) {
            sb.append(map.getKey() + "=" + map.getValue() + "&");
        }
        return url.concat(sb.substring(0, sb.length() - 1));
    }

    public static <T> String toJacksonJsonString(T t) {
        String json = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString(t);
        }
        catch (Exception e) {
            logger.error("Json\u8f6c\u6362\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        return json;
    }

    public static String generateSignature(String originString, String charset) {
        String signature = null;
        try {
            String encryptString = MD5Util.encodeTo32BitStr((String)originString);
            signature = Base64Utils.encodeToString((byte[])encryptString.getBytes(charset));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("\u52a0\u5bc6\u5931\u8d25\uff0c\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u52a0\u5bc6\u5931\u8d25\uff0c\u7f16\u7801\u683c\u5f0f\u4e0d\u652f\u6301");
        }
        return signature;
    }

    public static String getCurrentDate() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        return formatter.format(date);
    }

    public static Integer parseStatus(String camStatus) {
        int status = 0;
        if (StringUtils.isBlank((CharSequence)camStatus)) {
            return status;
        }
        try {
            status = Integer.parseInt(camStatus);
            status = status >= 1 ? 1 : 0;
        }
        catch (NumberFormatException e) {
            logger.error("\u62a5\u6587\u6570\u636e\u4e2dcamStatus\u6709\u95ee\u9898\uff0c\u4e0d\u80fd\u88ab\u89e3\u6790\u4e3a\u6570\u5b57");
        }
        return status;
    }

    public static Integer parseStringToInt(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.info("\u914d\u7f6e\u53c2\u6570\u6709\u95ee\u9898");
            return defaultValue;
        }
    }

    public static String generateSecretKey(String orgCode, String macAdress, String charset) {
        if (StringUtils.isBlank((CharSequence)orgCode) || StringUtils.isBlank((CharSequence)macAdress)) {
            return null;
        }
        try {
            charset = charset == null ? "GBK" : charset;
            String jsonBody = "{\"orgCode\":\"${orgCode}\",\"macAddress\":\"${macAddress}\"}".replace("${orgCode}", orgCode).replace("${macAddress}", macAdress);
            String base64Body = Base64Utils.encodeToString((byte[])jsonBody.getBytes(charset));
            return MD5Util.encode((String)base64Body, (String)charset);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("\u52a0\u5bc6\u7b97\u6cd5\u627e\u4e0d\u5230", e.getCause());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u52a0\u5bc6\u65f6\u9047\u5230\u4e86\u975e\u6cd5\u7f16\u7801", e.getCause());
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u65f6\u9047\u5230\u9519\u8bef", e.getCause());
        }
        return CommonUtil.generateSecretKey2((String)orgCode, (String)macAdress);
    }

    private static String generateSecretKey2(String orgCode, String macAdress) {
        StringBuilder buff = new StringBuilder();
        buff.append(System.currentTimeMillis()).append(macAdress.replaceAll("-", ""));
        return buff.toString();
    }

    public static Integer getCrsDeviceLine(String deviceNo) {
        Integer result = -1;
        if (StringUtils.isBlank((CharSequence)deviceNo)) {
            return result;
        }
        try {
            String lineNoStr = StringUtils.substring((String)deviceNo, (int)(deviceNo.length() - 2));
            result = Integer.valueOf(lineNoStr);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return result;
        }
        return result;
    }

    public static int getPageSize(int totalCount) {
        if (totalCount >= 10000) {
            return 1000;
        }
        if (totalCount >= 5000) {
            return 500;
        }
        if (totalCount >= 1000) {
            return 100;
        }
        return totalCount;
    }

    public static void main(String[] args) throws Exception {
        String str = "{\"expressNumber\":\"YT4460136025379\",\"nameNumber\":\"536010\",\"opCode\":\"171\",\"snNumber\":\"4C:D9:8F:4E:3B:31\",\"imgSource\":\"\",\"extend\":\"\"}";
        String signature = CommonUtil.encryptJsonToSignature((String)str, (String)"GBK");
        System.out.println(signature);
    }

    public static <T> void insertDataByPart(List<T> data, Consumer<List<T>> consumer, String exceptionDesc) {
        int totalCount = data.size();
        int pageSize = CommonUtil.getPageSize((int)totalCount);
        int start = 0;
        int end = 0;
        int pageIndex = 0;
        List<T> subList = null;
        for (int pageCount = (totalCount - 1) / pageSize + 1; pageCount > 0; --pageCount) {
            start = pageSize * pageIndex;
            end = pageCount > 1 ? start + pageSize : totalCount;
            subList = data.subList(start, end);
            if (!CollectionUtils.isEmpty(subList)) {
                try {
                    consumer.accept(subList);
                }
                catch (Exception e) {
                    logger.error(exceptionDesc, e.getCause());
                }
            }
            ++pageIndex;
        }
    }

    public static void deleteRecordsByPage(int saveDay, int pageSize, String tableName, BiFunction<Integer, Integer, Integer> deleteRecordsFunction) {
        int maxErrorCount = 10;
        int timeOut = 1;
        boolean continueFlag = true;
        int errorCount = 1;
        long startTime = System.currentTimeMillis();
        do {
            try {
                int resultCount = deleteRecordsFunction.apply(saveDay, pageSize);
                boolean bl = continueFlag = resultCount > 0;
                if ((System.currentTimeMillis() - startTime) / 3600000L < (long)timeOut) continue;
                logger.info("\u5220\u9664\u8868" + tableName + "\u5df2\u7ecf\u8d85\u8fc7" + timeOut + "\u5c0f\u65f6\uff0c\u7ec8\u6b62\u5220\u9664\u64cd\u4f5c");
                continueFlag = false;
            }
            catch (Exception e) {
                logger.error("\u5220\u9664\u6570\u636e\u8868" + tableName + "\u65f6\u51fa\u9519\uff0c\u7b2c" + errorCount + "\u6b21", e.getCause());
                boolean bl = continueFlag = ++errorCount <= maxErrorCount;
            }
        } while (continueFlag);
    }

    public static String doSign(String content, String charset, String key) {
        content = content + key;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(content.getBytes(charset));
            return Base64Utils.encodeToString((byte[])md.digest());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static OperationTotalData convertOriginData2TotalData(OperationStatisticEntity originData, Date currentDate) {
        OperationTotalData totalData = new OperationTotalData();
        totalData.setCenterCode(originData.getOrgCode());
        totalData.setClientMac(originData.getDevMac());
        totalData.setUserCode(originData.getUserCode());
        totalData.setUserName(originData.getUserName());
        totalData.setLastOperationDate(originData.getLastOperationDate());
        totalData.setRecordTime(currentDate);
        totalData.setSendStatus(Integer.valueOf(0));
        totalData.increment();
        return totalData;
    }

    public static OperationWeightData convertOriginData2WeightData(OperationStatisticEntity originData, Date currentDate) {
        OperationWeightData weightData = new OperationWeightData();
        weightData.setClientMac(originData.getDevMac());
        weightData.setWeighWeight(originData.getWeighWeight());
        weightData.setVolumeWeight(originData.getVolumeWeight());
        weightData.setLastOperationDate(originData.getLastOperationDate());
        weightData.setCenterCode(originData.getOrgCode());
        weightData.setDeviceType(Integer.parseInt(originData.getDevType()));
        weightData.setBussinessType(originData.getBussinessType());
        weightData.initCount();
        weightData.setRecordTime(currentDate);
        weightData.setSendStatus(Integer.valueOf(0));
        return weightData;
    }

    public static OperationLogData convertOriginData2LogData(OperationStatisticEntity originData, Date currentDate) {
        OperationLogData logData = new OperationLogData();
        logData.setClientMac(originData.getDevMac());
        logData.setOperationCount(1);
        logData.setVolumeWeight(originData.getVolumeWeight());
        logData.setWeighWeight(originData.getWeighWeight());
        if (originData.getVolumeWeight() > 0.0) {
            logData.setVolumeCount(1);
        } else {
            logData.setVolumeCount(0);
        }
        logData.setBussinessType(originData.getBussinessType());
        logData.setCenterCode(originData.getOrgCode());
        logData.setDeviceType(Integer.parseInt(originData.getDevType()));
        logData.setRecordTime(currentDate);
        logData.setSendStatus(Integer.valueOf(0));
        return logData;
    }

    public static <T> List<List<T>> groupDataListByPage(List<T> dataList, int pageSize) {
        int totalCount = dataList.size();
        ArrayList<List<T>> groupList = new ArrayList<List<T>>(dataList.size() / pageSize + 1);
        int start = 0;
        int end = 0;
        int pageIndex = 0;
        List<T> subList = null;
        for (int pageCount = (totalCount - 1) / pageSize + 1; pageCount > 0; --pageCount) {
            start = pageSize * pageIndex;
            end = pageCount > 1 ? start + pageSize : totalCount;
            subList = dataList.subList(start, end);
            if (!CollectionUtils.isEmpty(subList)) {
                groupList.add(subList);
            }
            ++pageIndex;
        }
        return groupList;
    }

    public static <T> ResponseEntity<T> sendPostRequest(RestTemplate restTemplate, String url, Object msgBody, Class<T> responseType) {
        ResponseEntity response = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("Accept", "application/json;charset=UTF-8");
        if (url.contains("/Yto_ManageWeb")) {
            SignUtil.sign4RestTemplate((HttpHeaders)headers);
        }
        HttpEntity httpEntity = new HttpEntity(msgBody, (MultiValueMap)headers);
        try {
            response = restTemplate.postForEntity(url, (Object)httpEntity, responseType, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42{}\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
        }
        return response;
    }

    public static <T> ResponseEntity<T> sendPostRequestNoCatch(RestTemplate restTemplate, String url, Object msgBody, Class<T> responseType) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("Accept", "application/json;charset=UTF-8");
        if (url.contains("/Yto_ManageWeb")) {
            SignUtil.sign4RestTemplate((HttpHeaders)headers);
        }
        HttpEntity httpEntity = new HttpEntity(msgBody, (MultiValueMap)headers);
        return restTemplate.postForEntity(url, (Object)httpEntity, responseType, new Object[0]);
    }

    public static <T> T sendPostRequest(RestTemplate restTemplate, String url, Object reqBody, Map<String, Object> urlParam, HttpHeaders headers, ParameterizedTypeReference<T> respType) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        }
        if (url.contains("/Yto_ManageWeb")) {
            SignUtil.sign4RestTemplate((HttpHeaders)headers);
        }
        HttpEntity httpEntity = new HttpEntity(reqBody, (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.exchange(CommonUtil.spliceUrl((String)url, urlParam), HttpMethod.POST, httpEntity, respType, new Object[0]);
        return (T)responseEntity.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(SafeProperties properties, String path, String comments) {
        if (properties == null) {
            return;
        }
        if (path == null || path.isEmpty()) {
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(path));
            properties.store((OutputStream)outputStream, comments);
        }
        catch (FileNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u914d\u7f6e\u6587\u4ef6\uff1a" + path);
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a" + path);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u65f6\uff0c\u8f93\u51fa\u6d41\u5173\u95ed\u5f02\u5e38\uff1a" + path);
            }
        }
    }

    public static String fixedSubstring(String str, int endIndex) {
        if (StringUtils.isEmpty((CharSequence)str) || endIndex <= 0) {
            return str;
        }
        return str.length() > endIndex ? str.substring(0, endIndex) : str;
    }
}

