/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.utils;

import com.yto.monitor.common.config.CustomLoggerFactory;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommonUtils {
    private static Logger logger = LoggerFactory.getLogger(CommonUtils.class);
    private static Logger sysLogger = CustomLoggerFactory.SystemLogger();
    public static final String TIME_ZONE_STANDARD_ID = "Asia/Shanghai";
    public static final String DATE_TIME_FORMAT_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_WINDOWS = "yyyy-MM-dd";
    public static final String DATE_FORMAT_LINUX = "yyyyMMdd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static TimeZone timeZoneStandard = TimeZone.getTimeZone("Asia/Shanghai");
    public static final String IP_ADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static InetAddress inetAddress = null;

    public static String convert(Date date, String format, TimeZone timeZone) {
        if (null != date) {
            if (StringUtils.isEmpty((CharSequence)format)) {
                format = "yyyy-MM-dd HH:mm:ss";
                logger.debug("format \u672a\u8d4b\u503c\u6216\u975e\u6cd5");
            }
            if (null == timeZone) {
                timeZone = timeZoneStandard;
                logger.debug("timeZone \u672a\u8d4b\u503c,\u53d6\u4e2d\u56fd\u6807\u51c6\u65f6\u533a");
            }
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setTimeZone(timeZone);
            return sdf.format(date);
        }
        return null;
    }

    public static String formatSSS(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        String timeText = format.format(date);
        return timeText;
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static Date parseDate(String date, String format) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        try {
            return simpleDateFormat.parse(date);
        }
        catch (ParseException e) {
            logger.error("\u5b57\u7b26\u4e32\u65f6\u95f4\u8f6cDate\u5bf9\u8c61\u5f02\u5e38,date:{},format:{}", new Object[]{date, format, e});
            return null;
        }
    }

    public static String getCurrentDate() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        return formatter.format(date);
    }

    public static String getClassPath() {
        return CommonUtils.enhancePath((String)Thread.currentThread().getContextClassLoader().getResource(".").getPath());
    }

    public static String enhancePath(String path) {
        if (path.startsWith("/") && (path = path.replaceFirst("/", "")).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.replaceAll("/", "\\\\");
    }

    public static <T> Map<String, Object> convertBeanToMap(T t) {
        HashMap<String, Object> mm = new HashMap<String, Object>();
        Class<?> clz = t.getClass();
        List names = Arrays.stream(clz.getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
        names.stream().forEach(name -> {
            try {
                Field field = clz.getDeclaredField((String)name);
                field.setAccessible(true);
                mm.put((String)name, field.get(t));
            }
            catch (Exception e) {
                logger.error(clz.getName() + "\u7c7b\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027 -> " + name);
            }
        });
        return mm;
    }

    public static List<Integer> convertToIntegerList(List<String> idList) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        try {
            for (String id : idList) {
                int primary = Integer.parseInt(id);
                ids.add(primary);
            }
        }
        catch (NumberFormatException e) {
            logger.error("\u524d\u7aef\u53c2\u6570\u4f20\u9012\u6709\u8bef\uff0c\u6279\u91cf\u5220\u9664\u65f6\uff0c\u4f20\u6765\u7684ID\u4e0d\u80fd\u89e3\u6790\u4e3a\u6570\u5b57");
            return null;
        }
        return ids;
    }

    public static boolean isNumeric(String str, int length) {
        Pattern pattern = Pattern.compile("\\d{" + length + "}");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isboolIp(String ipAddress) {
        String ip = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pattern = Pattern.compile(ip);
        Matcher matcher = pattern.matcher(ipAddress);
        return matcher.matches();
    }

    public static int compareVersion(String v1, String v2) {
        if (v1.equals(v2)) {
            return 0;
        }
        String[] version1Array = v1.split("[._]");
        String[] version2Array = v2.split("[._]");
        int minLen = Math.min(version1Array.length, version2Array.length);
        long diff = 0L;
        for (int index = 0; index < minLen && (diff = Long.parseLong(version1Array[index]) - Long.parseLong(version2Array[index])) == 0L; ++index) {
        }
        if (diff == 0L) {
            int i;
            for (i = index; i < version1Array.length; ++i) {
                if (Long.parseLong(version1Array[i]) <= 0L) continue;
                return 1;
            }
            for (i = index; i < version2Array.length; ++i) {
                if (Long.parseLong(version2Array[i]) <= 0L) continue;
                return -1;
            }
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }

    public static synchronized InetAddress getLocalHostLANAddress() {
        if (inetAddress != null) {
            return inetAddress;
        }
        try {
            ArrayList<InetAddress> candidateIpList = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.getHostAddress().contains(":") || inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        inetAddress = inetAddr;
                        return inetAddr;
                    }
                    if (!inetAddr.getHostAddress().matches("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$")) continue;
                    candidateIpList.add(inetAddr);
                }
            }
            if (!CollectionUtils.isEmpty(candidateIpList)) {
                inetAddress = (InetAddress)candidateIpList.get(0);
                return inetAddress;
            }
            inetAddress = InetAddress.getLocalHost();
            return inetAddress;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u672c\u673aIP\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static int getStrCount(String scrstr, char armstr) {
        if (StringUtils.isBlank((CharSequence)scrstr)) {
            return 0;
        }
        int count = 0;
        for (char c : scrstr.toCharArray()) {
            if (c != armstr) continue;
            ++count;
        }
        return count;
    }

    public static int getDay(int args, int dateType) {
        dateType = dateType > 0 ? dateType : 5;
        int day = 0;
        Calendar calendar = Calendar.getInstance();
        if (0 == args) {
            day = calendar.get(dateType);
        } else {
            calendar.add(dateType, -args);
            day = calendar.get(dateType);
        }
        return dateType == 7 ? (day - 1 == 0 ? 7 : day - 1) : day;
    }
}

