/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.utils;

import com.yto.monitor.adapter.utils.CommonUtils;
import com.yto.monitor.adapter.utils.FileUtil;
import com.yto.monitor.common.util.CMDUtil;
import java.io.File;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateTimeSynchronizeUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeSynchronizeUtil.class);
    private static final long DATETIME_DIFF = 90000L;
    private static final Object lock = new Object();

    public static boolean canSynchronizeByDiff(Date serverTime, Date localTime, long dateTimeDiff) {
        TimeZone tzClient = TimeZone.getDefault();
        if (!tzClient.getID().equals("Asia/Shanghai")) {
            logger.warn("\u672c\u673a\u975e\u6807\u51c6GMT+8:00\u65f6\u533a,\u4e0d\u66f4\u65b0\u672c\u5730\u65f6\u95f4; TimeZoneStandard=Asia/Shanghai, TimeZoneClient=" + tzClient.getID());
            return false;
        }
        return Math.abs(serverTime.getTime() - localTime.getTime()) > dateTimeDiff;
    }

    public static void dateTimeSynchronize(String serverTime) {
        Date date = CommonUtils.parseDate((String)serverTime, (String)"yyyy-MM-dd HH:mm:ss");
        DateTimeSynchronizeUtil.dateTimeSynchronize((Date)date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dateTimeSynchronize(Date serverTime) {
        Date currentLocalTime = new Date();
        if (serverTime != null && DateTimeSynchronizeUtil.canSynchronizeByDiff((Date)serverTime, (Date)currentLocalTime, (long)90000L)) {
            Object object = lock;
            synchronized (object) {
                logger.info("\u672c\u673a\u5f53\u524d\u65f6\u95f4:{} \u4e0e \u670d\u52a1\u5668\u5f53\u524d\u65f6\u95f4:{}\u5dee\u503c\u5927\u4e8e:{}\u6beb\u79d2,\u5f00\u59cb\u540c\u6b65\u670d\u52a1\u5668\u65f6\u95f4", new Object[]{currentLocalTime, serverTime, 90000L});
                DateTimeSynchronizeUtil.synchronizeSystemDateTime((Date)serverTime);
            }
        }
    }

    public static void synchronizeSystemDateTime(Date serverTime) {
        if (SystemUtils.IS_OS_WINDOWS) {
            DateTimeSynchronizeUtil.syncWindowsSystemDateTime((Date)serverTime);
        } else {
            DateTimeSynchronizeUtil.syncLinuxSystemDateTime((Date)serverTime);
        }
    }

    public static void syncWindowsSystemDateTime(Date serverTime) {
        try {
            String cmd = "";
            String strServerDate = CommonUtils.convert((Date)serverTime, (String)"yyyy-MM-dd", null);
            String strServerTime = CommonUtils.convert((Date)serverTime, (String)"HH:mm:ss", null);
            cmd = " cmd /c date " + strServerDate;
            Runtime.getRuntime().exec(cmd);
            cmd = " cmd /c time " + strServerTime;
            Runtime.getRuntime().exec(cmd);
            logger.info("\u8bbe\u7f6e\u672c\u673a\u65f6\u95f4\u5b8c\u6210(windows):" + strServerDate + " " + strServerTime);
        }
        catch (Exception e) {
            logger.info("\u8bbe\u7f6e\u672c\u673a\u65f6\u95f4\u5f02\u5e38(windows)", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncLinuxSystemDateTime(Date serverTime) {
        String strServerDateTime = CommonUtils.convert((Date)serverTime, (String)"yyyy-MM-dd HH:mm:ss", null);
        String script = FileUtil.getAppTempDir() + File.separator + "updateSysTime.sh";
        File file = new File(script);
        try {
            FileUtil.writeText((File)file, (String)("date -s\"" + strServerDateTime + "\""));
            String res = CMDUtil.excuteShFile((String)script, (String[])new String[0]);
            logger.info("\u8bbe\u7f6e\u672c\u673a\u65f6\u95f4\u5b8c\u6210(linux):" + strServerDateTime);
            logger.info("\u8bbe\u7f6e\u65f6\u95f4\u7ed3\u679c {}", (Object)res);
        }
        finally {
            file.delete();
        }
    }
}

