/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.utils;

import com.yto.monitor.adapter.constant.AdapterDeviceTypeEnum;
import com.yto.monitor.adapter.constant.ClientAdditionalEnum;
import com.yto.monitor.adapter.constant.ScanDeviceTypeEnum;
import com.yto.monitor.common.constant.DeviceTypeEnum;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DevTypeCalcUtils {
    public static final String SCAN_DEV_TYPE = "1";
    public static final String ADAPTER_DEV_TYPE = "2";
    public static final String ALL_RELATED_DEV_TYPE = "3";

    public static String calculateRelatedDevType(String devType, String refDevType) {
        String result = "0";
        if (devType == null) {
            return result;
        }
        DeviceTypeEnum enumByDeviceType = DeviceTypeEnum.getEnumByDeviceType((String)devType);
        if (Objects.isNull(enumByDeviceType)) {
            return result;
        }
        switch (refDevType) {
            case "1": {
                return enumByDeviceType.getScanType();
            }
            case "2": {
                return enumByDeviceType.getAdapterDevType();
            }
            case "3": {
                return enumByDeviceType.getScanType() + "," + enumByDeviceType.getAdapterDevType();
            }
        }
        return result;
    }

    public static boolean isAdaptedJCD(String devType) {
        return (AdapterDeviceTypeEnum.CROSSBELT.getType() + "").equals(DevTypeCalcUtils.calculateRelatedDevType((String)devType, (String)"2"));
    }

    public static Integer calculateDeviceType(Integer scanDevType, Integer adapterDevType, String additional, Integer devType) {
        if (scanDevType == null || adapterDevType == null || StringUtils.isBlank((CharSequence)additional)) {
            return devType;
        }
        if (scanDevType.intValue() == ScanDeviceTypeEnum.KUAISHOW.getType() && adapterDevType.intValue() == AdapterDeviceTypeEnum.NO.getType()) {
            List<String> additionalList = Arrays.asList(additional.split(","));
            if (additionalList.contains(ClientAdditionalEnum.NEED_VOLUME.getValue())) {
                return DeviceTypeEnum.BIG_FAST_HAND_JIPAO.getIndex();
            }
            if (additionalList.contains(ClientAdditionalEnum.ROLLER.getValue())) {
                return DeviceTypeEnum.BIG_FAST_HAND.getIndex();
            }
            return DeviceTypeEnum.FAST_HAND.getIndex();
        }
        DeviceTypeEnum realDevType = DeviceTypeEnum.getEnumByScanAndAdapterType((String)String.valueOf(scanDevType), (String)String.valueOf(adapterDevType));
        if (Objects.nonNull(realDevType)) {
            return realDevType.getIndex();
        }
        return devType;
    }

    public static void main(String[] args) {
        System.out.println(DevTypeCalcUtils.calculateRelatedDevType((String)"19", (String)"1"));
        System.out.println(DevTypeCalcUtils.calculateRelatedDevType((String)"19", (String)"2"));
    }
}

