/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.utils;

import com.alibaba.fastjson.JSONObject;
import com.yto.monitor.adapter.service.security.SecurityService;
import com.yto.monitor.adapter.utils.CommonUtil;
import com.yto.monitor.common.entity.response.HttpBaseResponse;
import com.yto.monitor.common.http.ClientHttpResponse;
import com.yto.monitor.common.util.AlibabaJsonUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class HttpRequestUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SecurityService securityService;

    public HttpBaseResponse doPost(String url, Object msgBody, Map urlRequestParam) {
        return this.doPost(url, msgBody, urlRequestParam, false, true);
    }

    public HttpBaseResponse doPost(String url, Object msgBody, Map urlRequestParam, Integer timeOut) {
        return this.doPost(url, msgBody, urlRequestParam, false, true);
    }

    public HttpBaseResponse doPost(String url, Object msgBody, Map urlRequestParam, boolean needLog) {
        return this.doPost(url, msgBody, urlRequestParam, false, needLog);
    }

    public HttpBaseResponse doPost(String url, Object msgBody, Map urlRequestParam, boolean security, boolean needLog) {
        HttpBaseResponse response = this.postForEntity(url, msgBody, urlRequestParam, security, null, needLog);
        return response;
    }

    private HttpBaseResponse postForEntity(String url, Object msgBody, Map urlRequestParam, boolean security, Integer timeOut, boolean needLog) {
        HttpHeaders headers = new HttpHeaders();
        if (needLog) {
            this.logger.info("URL\uff1a{}", (Object)url);
        }
        if (msgBody != null && needLog) {
            this.logger.info("RequestBody\uff1a{}", (Object)JSONObject.toJSONString((Object)msgBody));
        }
        if (urlRequestParam != null && needLog) {
            this.logger.info("Param\uff1a{}", (Object)JSONObject.toJSONString((Object)urlRequestParam));
        }
        int time_out = timeOut == null ? 5000 : timeOut;
        String response = CommonUtil.sendRequest((RestTemplate)CommonUtil.getRestTemplate((int)time_out), (String)url, (Object)msgBody, (Map)urlRequestParam, (HttpHeaders)headers);
        if (needLog) {
            this.logger.info("Response\uff1a" + response);
        }
        if (null == response) {
            return HttpBaseResponse.fail((String)"response is null");
        }
        JSONObject jsonObject = AlibabaJsonUtil.toJSONObject((String)response);
        if (jsonObject.get((Object)"respCode") != null) {
            HttpBaseResponse result = (HttpBaseResponse)CommonUtil.parseJsonToPojo((String)response, HttpBaseResponse.class);
            return result;
        }
        ClientHttpResponse result = (ClientHttpResponse)CommonUtil.parseJsonToPojo((String)response, ClientHttpResponse.class);
        return new HttpBaseResponse(result.getRespcode(), result.getRespMessage(), result.getData());
    }
}

