/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.utils;

import cn.com.yto56.basic.framework.core.util.StringUtil;
import com.yto.monitor.adapter.constant.AutoDeviceTypeEnum;
import com.yto.monitor.adapter.constant.LatticeOptTypeEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class LatticeUtil {
    public static String checkLatticeNo(String latticeNo, boolean checkEmpty) {
        String[] latticeNoArr;
        boolean isBlank = StringUtils.isBlank((String)latticeNo);
        if (checkEmpty && isBlank) {
            return "\u683c\u53e3\u53f7\u4e3a\u7a7a";
        }
        if (!checkEmpty && isBlank) {
            return null;
        }
        if (!LatticeUtil.checkLatticeNoRepeat((String)latticeNo)) {
            return "\u683c\u53e3\u53f7\u91cd\u590d";
        }
        for (String s : latticeNoArr = latticeNo.split(",|;")) {
            if (s.length() <= 4) continue;
            return "\u683c\u53e3\u53f7[" + s + "]\u5927\u4e8e4\u4f4d";
        }
        return null;
    }

    private static boolean checkLatticeNoRepeat(String latticeNo) {
        List<String> latlist = Arrays.asList(latticeNo.replace(";", ",").split(","));
        HashSet<String> latSet = new HashSet<String>(latlist);
        return latlist.size() == latSet.size();
    }

    public static boolean needCheckThreeCodeEmpty(String deviceType) {
        return AutoDeviceTypeEnum.CROSSBELT.getType().equals(deviceType);
    }

    public static String transferLatticeNo(String latticeNo) {
        if (StringUtils.isBlank((String)latticeNo)) {
            return "";
        }
        Object[] latticeNoByOptArr = latticeNo.split(";");
        for (int i = 0; i < latticeNoByOptArr.length; ++i) {
            Object[] latticeNos = latticeNoByOptArr[i].split(",");
            for (int j = 0; j < latticeNos.length; ++j) {
                if (((String)latticeNos[j]).length() >= 3) continue;
                latticeNos[j] = StringUtil.leftPad((String)latticeNos[j], (int)3, (char)'0');
            }
            Arrays.sort(latticeNos);
            latticeNoByOptArr[i] = StringUtils.join((Object[])latticeNos, (String)",");
        }
        return StringUtils.join((Object[])latticeNoByOptArr, (String)";");
    }

    public static boolean threeCodeCheck(String threeCode, boolean checkEmpty, boolean needCheck) {
        String regex;
        if (StringUtils.isBlank((String)threeCode)) {
            return !checkEmpty;
        }
        if (!needCheck) {
            return true;
        }
        if ((threeCode = threeCode.replace(" ", "-")).matches(regex = "^\\d{6}$|^\\d{8}$")) {
            return true;
        }
        if (threeCode.endsWith("-")) {
            return false;
        }
        if (threeCode.startsWith("-") && threeCode.length() > 1 && StringUtils.countMatches((String)threeCode, (String)"-") == 1) {
            return true;
        }
        String[] split = threeCode.split("-");
        if (split.length == 0) {
            return false;
        }
        for (String s : split) {
            if (s.length() == 2 || s.length() == 3) continue;
            return false;
        }
        return true;
    }

    public static boolean threeCodeNeedCheck(String deviceType, String optFlag) {
        if (!AutoDeviceTypeEnum.CROSSBELT.getType().equals(deviceType) || StringUtils.isBlank((String)optFlag)) {
            return false;
        }
        List<String> needCheckOptList = Arrays.asList(LatticeOptTypeEnum.DISPATCH.getType(), LatticeOptTypeEnum.COUNTRY_STATION.getType(), LatticeOptTypeEnum.WAREHOUSE_SCAN.getType());
        List<String> optFlatList = Arrays.asList(optFlag.split(";"));
        return CollectionUtils.isNotEmpty((Collection)CollectionUtils.intersection(needCheckOptList, optFlatList));
    }
}

