/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.utils;

import cn.hutool.http.HttpUtil;
import com.google.gson.reflect.TypeToken;
import com.yto.monitor.adapter.config.SysPropertiesConfig;
import com.yto.monitor.adapter.config.UpgradeConfig;
import com.yto.monitor.adapter.config.UrlConfig;
import com.yto.monitor.adapter.utils.CommonUtil;
import com.yto.monitor.adapter.utils.FileUtil;
import com.yto.monitor.adapter.utils.YmlFileUtils;
import com.yto.monitor.common.component.SafeProperties;
import com.yto.monitor.common.config.CustomLoggerFactory;
import com.yto.monitor.common.entity.AppUpdateEntity;
import com.yto.monitor.common.entity.AppVersionEntity;
import com.yto.monitor.common.http.ClientHttpResponse;
import com.yto.monitor.common.util.ZipUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StopWatch;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class UpgradeUtils {
    public static final String UPGRADE_FILE_NAME = "upgrade.properties";
    public static final String APPLICATION_YML_NAME = "application.yml";
    public static final String UPGRADE_KEY_YML = "ymlKey";
    public static final String UPGRADE_KEY_PROPERTIES = "propertiesKey";
    public static final String CONFIG_FILE_PATH = "config";
    public static final String APP_FILENAME_PREFIX = "exp_adapter_";
    public static final String APP_FILENAME_SUFFIX = ".zip";
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private final ThreadLocal<UpgradeConfig> upgradeConfigLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifySettingFiles(File newFile) {
        UpgradeConfig upgradeConfig = this.getUpgradeConfig(newFile);
        this.upgradeConfigLocal.set(upgradeConfig);
        File oldFile = null;
        try {
            oldFile = new File(FileUtil.getAppDir());
            boolean modifyPropertiesResult = this.modifyPropertiesSettingFiles(newFile, oldFile);
            boolean modifyYmlResult = this.modifyYmlSettingFiles(newFile, oldFile);
            boolean bl = modifyPropertiesResult && modifyYmlResult;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u914d\u7f6e\u5f02\u5e38 new file:{}, old file:{}", new Object[]{newFile, oldFile, e});
            boolean bl = false;
            return bl;
        }
        finally {
            this.upgradeConfigLocal.remove();
        }
    }

    public UpgradeConfig getUpgradeConfig(File newFile) {
        File newConfigPath = new File(newFile.getPath() + File.separator + "config" + File.separator + "upgrade.properties");
        UpgradeConfig upgradeConfig = new UpgradeConfig();
        SafeProperties properties = new SafeProperties();
        try (FileInputStream oldInputStream = new FileInputStream(newConfigPath);){
            properties.load((InputStream)oldInputStream);
            Set keys = properties.getPropertyNames();
            for (String key : keys) {
                if ("ymlKey".equals(key)) {
                    upgradeConfig.setYmlKeys(properties.getProperty(key));
                }
                if (!"propertiesKey".equals(key)) continue;
                upgradeConfig.setCommonConfigKeys(properties.getProperty(key));
            }
        }
        catch (IOException e) {
            logger.error("\u89e3\u6790upgrade.properties\u5f02\u5e38 \uff1a{}", (Object)newConfigPath, (Object)e);
        }
        return upgradeConfig;
    }

    public boolean modifyPropertiesSettingFiles(File newFile, File oldFile) {
        logger.info("=============\u5347\u7ea7\u4fee\u6539config=================");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        File newConfigPath = new File(newFile.getPath() + File.separator + "config");
        logger.info("\u65b0config\u8def\u5f84\uff1a{}", (Object)newConfigPath.getPath());
        File oldConfigPath = new File(oldFile.getPath() + File.separator + "config");
        logger.info("\u65e7\u7684config\u8def\u5f84\uff1a{}", (Object)oldConfigPath.getPath());
        File[] newConfigFiles = newConfigPath.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (newConfigFiles == null || newConfigFiles.length == 0) {
            logger.info("\u65b0config\u8def\u5f84\u4e2d\u65e0properties\u6587\u4ef6");
            return false;
        }
        for (File newConfigFile : newConfigFiles) {
            File oldConfigFile;
            String configFileName = newConfigFile.getName();
            if (configFileName.toLowerCase().startsWith("upgrade") || !(oldConfigFile = new File(oldConfigPath.getPath() + File.separator + configFileName)).exists()) continue;
            SafeProperties newProperties = new SafeProperties();
            SafeProperties oldProperties = new SafeProperties();
            try (FileInputStream newInputStream = new FileInputStream(newConfigFile);
                 FileInputStream oldInputStream = new FileInputStream(oldConfigFile);){
                newProperties.load((InputStream)newInputStream);
                oldProperties.load((InputStream)oldInputStream);
                Set keys = newProperties.getPropertyNames();
                for (String key : keys) {
                    String oldProperty = oldProperties.getProperty(key);
                    if (!StringUtils.isNotBlank((CharSequence)oldProperty) || ((UpgradeConfig)this.upgradeConfigLocal.get()).containsCommonKey(key)) continue;
                    newProperties.setProperty(key, oldProperty);
                }
                CommonUtil.saveProperties((SafeProperties)newProperties, (String)newConfigFile.getPath(), null);
                logger.info("\u5904\u7406properties\u6587\u4ef6\u5b8c\u6210\uff1a{}", (Object)newConfigFile.getAbsolutePath());
            }
            catch (IOException e) {
                logger.error("\u4fee\u6539\u914d\u7f6e\u6587\u4ef6" + newConfigFile.getPath() + "\u51fa\u9519", (Throwable)e);
            }
        }
        stopWatch.stop();
        logger.info("\u5347\u7ea7copy properties\u6587\u4ef6\u7ed3\u675f,\u7528\u65f6{}", (Object)stopWatch.getTotalTimeMillis());
        return true;
    }

    public boolean modifyYmlSettingFiles(File newFile, File oldFile) {
        logger.info("=============\u5347\u7ea7\u4fee\u6539application.yml=================");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        File newYmlPath = new File(newFile.getPath() + File.separator + "application.yml");
        logger.info("\u65b0yml\u6587\u4ef6\uff1a{}", (Object)newYmlPath.getPath());
        File oldYmlPath = new File(oldFile.getPath() + File.separator + "application.yml");
        logger.info("\u65e7yml\u6587\u4ef6\uff1a{}", (Object)oldYmlPath.getPath());
        try (FileInputStream newInputStream = new FileInputStream(newYmlPath);
             FileInputStream oldInputStream = new FileInputStream(oldYmlPath);
             InputStreamReader newInputStreamReader = new InputStreamReader((InputStream)newInputStream, StandardCharsets.UTF_8);
             InputStreamReader oldInputStreamReader = new InputStreamReader((InputStream)oldInputStream, StandardCharsets.UTF_8);
             FileOutputStream fileOutputStream = new FileOutputStream(newYmlPath, true);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
             BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);){
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml newYaml = new Yaml(options);
            Yaml oldYaml = new Yaml();
            Map newYmlMap = (Map)newYaml.loadAs((Reader)newInputStreamReader, Map.class);
            Map oldYmlMap = (Map)oldYaml.loadAs((Reader)oldInputStreamReader, Map.class);
            this.recursionMap(newYmlMap, oldYmlMap);
            logger.info("\u5f00\u59cb\u6301\u4e45\u5316\u65b0yml...");
            UpgradeUtils.clearInfoForFile((String)newYmlPath.getPath());
            newYaml.dump((Object)newYmlMap, (Writer)bufferedWriter);
            logger.info("\u6301\u4e45\u5316\u65b0yml\u5b8c\u6210");
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u914d\u7f6e\u6587\u4ef6" + newYmlPath.getPath() + "\u51fa\u9519", (Throwable)e);
            return false;
        }
        stopWatch.stop();
        logger.info("\u5347\u7ea7copy yml\u6587\u4ef6\u7ed3\u675f,\u7528\u65f6{}", (Object)stopWatch.getTotalTimeMillis());
        return true;
    }

    public static void clearInfoForFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write("");
        fileWriter.flush();
        fileWriter.close();
        logger.info("\u5df2\u6e05\u7a7a\u6587\u4ef6\uff1a{}", (Object)fileName);
    }

    private void recursionMap(Map<String, Object> newYmlMap, Map<String, Object> oldYmlMap) {
        List newYmlKeyChains = YmlFileUtils.getAllKeyChains(newYmlMap);
        for (String keyChain : newYmlKeyChains) {
            Object oldValue;
            if (((UpgradeConfig)this.upgradeConfigLocal.get()).containsYmlKey(keyChain) || (oldValue = YmlFileUtils.getValue(oldYmlMap, (String)keyChain, (boolean)false)) == null) continue;
            YmlFileUtils.setMapValue(newYmlMap, (String)keyChain, (Object)oldValue);
        }
    }

    public static File unZipAppFile(File newAppFile, String targetDir) {
        try {
            ZipUtil.unZip((File)newAppFile, (String)targetDir);
            UpgradeUtils.coverBatFile((String)targetDir);
            return new File(targetDir);
        }
        catch (IOException e) {
            logger.error("\u89e3\u538bZip\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static void coverBatFile(String filePath) throws IOException {
        File destDir = new File(filePath);
        File oldFile = new File(FileUtil.getAppDir());
        for (File file : oldFile.listFiles()) {
            if (file.isDirectory() || !file.getName().toLowerCase().equals("exp_monitor_adapter.xml")) continue;
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    public static File saveAppFileToLocalDisk(MultipartFile file) {
        try {
            File appFile = new File(FileUtil.getUpgradePkgMonitorDir() + File.separator + file.getOriginalFilename());
            FileUtils.deleteQuietly((File)appFile);
            file.transferTo(appFile);
            return appFile;
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public static File getNewAppFromLocal(String version) {
        return new File(FileUtil.getUpgradePkgMonitorDir() + File.separator + "exp_adapter_" + version + ".zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveAppFileToTemp(byte[] file, String fileName) {
        File[] files;
        File file2;
        if (file == null || file.length == 0) {
            logger.error("\u4fdd\u5b58\u76d1\u63a7\u7f51\u5173\u5305\u5931\u8d25\uff1a\u6587\u4ef6\u4e3a\u7a7a {}", (Object)fileName);
            return null;
        }
        String directoryPath = FileUtil.getUpgradePkgMonitorDir();
        File appFile = new File(directoryPath + File.separator + fileName);
        try {
            FileUtils.writeByteArrayToFile((File)appFile, (byte[])file);
            file2 = appFile;
            files = new File(directoryPath).listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            File[] files2;
            File file3;
            try {
                logger.error("\u4fdd\u5b58\u6587\u4ef6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                file3 = null;
                files2 = new File(directoryPath).listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Throwable throwable) {
                File[] files3 = new File(directoryPath).listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
                if (files3 != null && files3.length > 0) {
                    for (File file1 : files3) {
                        if (FileUtils.deleteQuietly((File)file1)) {
                            logger.info("\u5220\u9664\u65e7\u6587\u4ef6\uff1a{}", (Object)file1.getAbsolutePath());
                            continue;
                        }
                        logger.info("\u5220\u9664\u65e7\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)file1.getAbsolutePath());
                    }
                }
                throw throwable;
            }
            if (files2 != null && files2.length > 0) {
                for (File file1 : files2) {
                    if (FileUtils.deleteQuietly((File)file1)) {
                        logger.info("\u5220\u9664\u65e7\u6587\u4ef6\uff1a{}", (Object)file1.getAbsolutePath());
                        continue;
                    }
                    logger.info("\u5220\u9664\u65e7\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)file1.getAbsolutePath());
                }
            }
            return file3;
        }
        if (files != null && files.length > 0) {
            for (File file1 : files) {
                if (FileUtils.deleteQuietly((File)file1)) {
                    logger.info("\u5220\u9664\u65e7\u6587\u4ef6\uff1a{}", (Object)file1.getAbsolutePath());
                    continue;
                }
                logger.info("\u5220\u9664\u65e7\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)file1.getAbsolutePath());
            }
        }
        return file2;
    }

    public static File saveAppFileToLocalDisk(byte[] fileByte, String file) {
        if (fileByte == null || fileByte.length == 0) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff1a\u6587\u4ef6\u4e3a\u7a7a");
            return null;
        }
        File appFile = new File(file);
        if (!appFile.getParentFile().exists() && !appFile.getParentFile().mkdirs()) {
            logger.error("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff1a{}", (Object)appFile.getParentFile());
        }
        if (appFile.exists() && appFile.isFile() && !appFile.delete()) {
            logger.error("\u65e7\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1a{}", (Object)appFile);
        }
        try (FileOutputStream fos = new FileOutputStream(appFile);){
            fos.write(fileByte);
            fos.flush();
        }
        catch (IOException e) {
            logger.error("\u672c\u5730\u5199\u6587\u4ef6IO\u5f02\u5e38", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error("\u672c\u5730\u5199\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return appFile;
    }

    public static String createUnzipDir(String version, String oldVersion) {
        File localAppFile = new File(FileUtil.getAppDir());
        String newAppPathName = localAppFile.getName();
        try {
            if (localAppFile.getName().endsWith(oldVersion)) {
                newAppPathName = localAppFile.getName().substring(0, localAppFile.getName().lastIndexOf("_"));
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u65b0\u7248\u672c\u5e94\u7528\u7684\u90e8\u7f72\u8def\u5f84\u5931\u8d25", (Throwable)e);
        }
        return localAppFile.getParent() + File.separator + newAppPathName + "_" + version;
    }

    public static byte[] getResource(String appUrl, String base64UserMsg) {
        logger.info("\u6b63\u5728\u4e0b\u8f7d\u5b89\u88c5\u5305 {}", (Object)appUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64UserMsg);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        RestTemplate restTemp = CommonUtil.getRestTemplate((int)300000);
        long l = System.currentTimeMillis();
        byte[] fileBinary = (byte[])restTemp.exchange(appUrl, HttpMethod.GET, entity, byte[].class, new Object[0]).getBody();
        logger.info("\u5b89\u88c5\u5305\u4e0b\u8f7d\u6210\u529f!,\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - l));
        return fileBinary;
    }

    public static byte[] getResource(String appUrl) {
        logger.info("\u6b63\u5728\u4e0b\u8f7d\u5b89\u88c5\u5305oss {}", (Object)appUrl);
        long l = System.currentTimeMillis();
        byte[] fileBinary = HttpUtil.downloadBytes((String)appUrl);
        logger.info("\u5b89\u88c5\u5305\u4e0b\u8f7d\u6210\u529f!,\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - l));
        return fileBinary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileSha1(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            String string = DigestUtils.sha1Hex((InputStream)fis);
            return string;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6sha1\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMd5(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            String string = DigestUtils.md5Hex((InputStream)fis);
            return string;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6md5\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static AppVersionEntity remoteAppVersion(String currentVersion, String appName, String mac) {
        AppUpdateEntity request = new AppUpdateEntity();
        request.setAppName(appName);
        request.setOrgCode(SysPropertiesConfig.getOrgCode());
        request.setAppVersion(currentVersion);
        request.setMac(mac);
        String respStr = CommonUtil.sendRequest((RestTemplate)CommonUtil.getRestTemplate((int)5000), (String)UrlConfig.MethodEnum.checkAppMaxVersion.getMethod(), (Object)request, null);
        logger.info("\u83b7\u53d6\u5ba2\u6237\u7aef\u6700\u5927\u7248\u672c\u53f7\u54cd\u5e94\uff1a{}", (Object)respStr);
        if (StringUtils.isBlank((CharSequence)respStr)) {
            return null;
        }
        ClientHttpResponse responseEntity = (ClientHttpResponse)CommonUtil.convertJsonToBean((String)respStr, (TypeToken)new /* Unavailable Anonymous Inner Class!! */);
        return responseEntity != null ? (AppVersionEntity)responseEntity.getData() : null;
    }

    public static String getRestartScriptName() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "restart.bat";
        }
        return "restart.sh";
    }
}

