/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.utils.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.listener.ReadListener;
import com.yto.monitor.adapter.entity.excel.BaseImportBody;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizeReadListener<T extends BaseImportBody>
implements ReadListener<LinkedHashMap<Integer, String>> {
    private static final Logger logger = LoggerFactory.getLogger(CustomizeReadListener.class);
    private boolean headFullWordMatch = false;
    private Map<String, Integer> fieldValue = new HashMap();
    public Class<T> classType;
    private List<T> excelData = new ArrayList();
    private Map<Integer, String> headMap = new LinkedHashMap();
    private Consumer<Map<Integer, String>> headValidator;
    private Consumer<T> bodyValidator;

    public void setHeadFullWordMatch(boolean headFullWordMatch) {
        this.headFullWordMatch = headFullWordMatch;
    }

    public List<T> getExcelData() {
        return this.excelData;
    }

    public Map<Integer, String> getHeadMap() {
        return this.headMap;
    }

    public CustomizeReadListener(Class<T> classType) {
        this.classType = classType;
    }

    public CustomizeReadListener(Class<T> classType, Consumer<Map<Integer, String>> headValidator) {
        this.classType = classType;
        this.headValidator = headValidator;
    }

    public CustomizeReadListener(Class<T> classType, Consumer<Map<Integer, String>> headValidator, Consumer<T> bodyValidator) {
        this.classType = classType;
        this.headValidator = headValidator;
        this.bodyValidator = bodyValidator;
    }

    public void invokeHead(Map<Integer, ReadCellData<?>> cellHeadMap, AnalysisContext context) {
        for (Map.Entry<Integer, ReadCellData<?>> entry : cellHeadMap.entrySet()) {
            this.headMap.put(entry.getKey(), entry.getValue().getStringValue());
        }
        this.headMap = this.headMap.entrySet().stream().filter(e -> StringUtils.isNotBlank((String)((String)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (this.headValidator != null) {
            this.headValidator.accept(this.headMap);
        }
        this.fieldValue.putAll(this.fieldValueSet(this.headMap, this.classType));
    }

    public void invoke(LinkedHashMap<Integer, String> body, AnalysisContext analysisContext) {
        BaseImportBody t = null;
        try {
            t = (BaseImportBody)this.classType.newInstance();
        }
        catch (Exception e) {
            logger.error("\u5b9e\u4f8b\u5316excel\u6570\u636e\u5b9e\u4f53\u5f02\u5e38", (Throwable)e);
        }
        if (t == null) {
            return;
        }
        this.setFieldValue(body, this.fieldValue, t);
        t.setRowIndex(analysisContext.readRowHolder().getRowIndex());
        if (this.bodyValidator != null) {
            this.bodyValidator.accept(t);
        }
        this.excelData.add(t);
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
    }

    public Map<String, Integer> fieldValueSet(Map<Integer, String> headMap, Class<T> cla) {
        Field[] fields;
        HashMap<String, Integer> fieldValue = new HashMap<String, Integer>();
        for (Field field : fields = cla.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExcelProperty.class)) continue;
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            block1: for (Map.Entry<Integer, String> entry : headMap.entrySet()) {
                for (String s : excelProperty.value()) {
                    if (!StringUtils.isNotBlank((String)entry.getValue()) || !(this.headFullWordMatch ? entry.getValue().equals(s) : entry.getValue().startsWith(s))) continue;
                    fieldValue.put(field.getName(), entry.getKey());
                    continue block1;
                }
            }
        }
        return fieldValue;
    }

    private void setFieldValue(Map<Integer, String> valueMap, Map<String, Integer> fieldValue, T obj) {
        Field[] fields;
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExcelProperty.class) || !fieldValue.containsKey(field.getName())) continue;
            field.setAccessible(true);
            try {
                Integer colIndex = fieldValue.get(field.getName());
                field.set(obj, valueMap.get(colIndex));
            }
            catch (IllegalAccessException e) {
                logger.error("\u8bbe\u7f6e\u5c5e\u6027\u5f02\u5e38 {}", (Object)field, (Object)e);
            }
        }
    }
}

