/*
 * Decompiled with CFR 0.152.
 */
package com.yto.monitor.adapter.utils.excel;

import com.yto.monitor.adapter.constant.AutoDeviceTypeEnum;
import com.yto.monitor.adapter.constant.LatticeOptTypeEnum;
import com.yto.monitor.adapter.constant.LatticeStatusEnum;
import com.yto.monitor.adapter.constant.SortingTypeEnum;
import com.yto.monitor.adapter.entity.excel.CrossBeltLatticeImportBody;
import com.yto.monitor.adapter.entity.excel.EndLineLatticeImportBody;
import com.yto.monitor.adapter.entity.excel.LatDetailCfg1ImportBody;
import com.yto.monitor.adapter.entity.excel.LatDetailCfg2ImportBody;
import com.yto.monitor.adapter.entity.excel.UnloadWithDispatchImportBody;
import com.yto.monitor.adapter.entity.response.BaseResp;
import com.yto.monitor.adapter.utils.LatticeUtil;
import com.yto.monitor.adapter.utils.excel.ExcelUtil;
import com.yto.monitor.common.constant.UserProfileEnum;
import com.yto.monitor.common.exception.ImportExcelException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExcelUtil {
    public static final List<LatticeExcelInstructions> LATTICE_EXCEL_INSTRUCTIONS = new ArrayList();
    public static final String OPT_FLAG_REGEX = "^[\\u4e00-\\u9fa50-9;]+$";
    public static final String LATTICE_NO_REGEX = "^[0-9;,]+$";
    public static final List<String> REQUIRED_LATTICE_HEAD;
    public static final List<String> REQUIRED_ENDLINE_LATTICE_HEAD;
    public static final List<String> REQUIRED_UNLOAD_WITH_DISPATCH_HEAD;
    public static final Consumer<Map<Integer, String>> HEAD_VALIDATOR_CROSSBELT_LATTICE;
    public static final Consumer<Map<Integer, String>> HEAD_VALIDATOR_UNLOAD_WITH_DISPATCH;
    public static final Consumer<Map<Integer, String>> HEAD_VALIDATOR_ENDLINE_LATTICE;
    public static final List<String> REQUIRED_LATTICE_DETAIL2;
    public static final List<String> REQUIRED_LATTICE_DETAIL2_CENTER;
    public static final Consumer<Map<Integer, String>> HEAD_VALIDATOR_LATTICE_DETAIL2;
    public static final Consumer<Map<Integer, String>> HEAD_VALIDATOR_LATTICE_DETAIL2_CENTER;
    public static final List<String> REQUIRED_LATTICE_DETAIL3;
    public static final List<String> REQUIRED_WEIGHT_SORTING;
    public static final Consumer<Map<Integer, String>> HEAD_VALIDATOR_LATTICE_DETAIL3;
    public static final Consumer<Map<Integer, String>> HEAD_VALIDATOR_WEIGHT_SORTING;
    public static final Consumer<CrossBeltLatticeImportBody> BODY_VALIDATOR_CROSSBELT_LATTICE;
    public static final Consumer<UnloadWithDispatchImportBody> BODY_VALIDATOR_UNLOAD_WITH_DISPATCH;
    public static final Consumer<EndLineLatticeImportBody> BODY_VALIDATOR_ENDLINE_LATTICE;
    public static final Consumer<LatDetailCfg1ImportBody> BODY_VALIDATOR_LATTICE_DETAIL1;
    public static final Consumer<LatDetailCfg2ImportBody> BODY_VALIDATOR_LATTICE_DETAIL2;
    public static final Consumer<LatDetailCfg2ImportBody> BODY_VALIDATOR_LATTICE_DETAIL2_CENTER;
    public static final Map<String, List<String>> LATTICE_DETAIL1_HEAD;

    public static BaseResp<LatticeOptTypeEnum> allowOptCheck(List<LatticeOptTypeEnum> enums, String optFlag) {
        for (LatticeOptTypeEnum optTypeEnum : enums) {
            if (!optTypeEnum.getType().equals(optFlag) && !optTypeEnum.getName().equals(optFlag)) continue;
            return BaseResp.success((Object)optTypeEnum);
        }
        return BaseResp.fail((String)("\u4e0d\u5141\u8bb8\u7684\u64cd\u4f5c\u7c7b\u578b\uff1a" + optFlag));
    }

    public static boolean checkOptGroup(String opt, String latticeNo) {
        String[] latticeNoSplit;
        if (StringUtils.isBlank((String)opt) && StringUtils.isBlank((String)latticeNo)) {
            return true;
        }
        if (StringUtils.isBlank((String)opt) && StringUtils.isNotBlank((String)latticeNo) || StringUtils.isNotBlank((String)opt) && StringUtils.isBlank((String)latticeNo)) {
            return false;
        }
        String[] optSplit = opt.split(";");
        if (optSplit.length != (latticeNoSplit = latticeNo.split(";")).length) {
            return false;
        }
        for (int i = 0; i < optSplit.length; ++i) {
            if ((!StringUtils.isNotBlank((String)optSplit[i]) || !StringUtils.isBlank((String)latticeNoSplit[i])) && (!StringUtils.isBlank((String)optSplit[i]) || !StringUtils.isNotBlank((String)latticeNoSplit[i]))) continue;
            return false;
        }
        return true;
    }

    public static void setResponse(HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        response.setCharacterEncoding("UTF-8");
        response.setHeader("content-Type", "application/vnd.ms-excel");
        response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        response.setHeader("access-control-expose-headers", "*");
        response.setHeader("overwrite-response-data", "true");
        response.setContentType("application/octet-stream;charset=UTF-8");
    }

    public static BaseResp latDetail1HeadCheck(String sortingType, Map<Integer, String> headMap) {
        List strings = (List)LATTICE_DETAIL1_HEAD.get(sortingType);
        for (String headName : strings) {
            boolean exist = false;
            for (String value : headMap.values()) {
                if (!value.startsWith(headName)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            return BaseResp.fail((String)("Excel\u7f3a\u5c11\u5217\uff1a" + headName + "\uff0c\u8bf7\u67e5\u770b\u793a\u4f8b\u56fe"));
        }
        return BaseResp.success(null);
    }

    public static String optFlagToNumber(String optFlag) {
        if (StringUtils.isBlank((String)optFlag)) {
            return LatticeOptTypeEnum.NORMAL.getType();
        }
        if (optFlag.contains(";")) {
            String[] split = optFlag.split(";");
            StringJoiner joiner = new StringJoiner(";");
            for (String s : split) {
                String optNumber = ExcelUtil.singleOptToNumber((String)s);
                if (!StringUtils.isNotBlank((String)optNumber)) continue;
                joiner.add(optNumber);
            }
            String multiOpt = null;
            multiOpt = joiner.toString();
            return StringUtils.isNotBlank((String)multiOpt) ? multiOpt : LatticeOptTypeEnum.NORMAL.getType();
        }
        String optNumber = null;
        optNumber = ExcelUtil.singleOptToNumber((String)optFlag);
        return StringUtils.isNotBlank((String)optNumber) ? optNumber : LatticeOptTypeEnum.NORMAL.getType();
    }

    public static String userProfileToName(String userProfile) {
        String[] split;
        if (StringUtils.isBlank((String)userProfile)) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (String s : split = userProfile.split(",")) {
            UserProfileEnum byCode = UserProfileEnum.getByCode((String)s);
            if (byCode == null) continue;
            joiner.add(byCode.getName());
        }
        return joiner.toString();
    }

    public static String userProfileToCode(String userProfile) {
        if (StringUtils.isBlank((String)userProfile)) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(",");
        List collect = Arrays.stream(userProfile.split(",|\uff0c")).distinct().collect(Collectors.toList());
        for (String s : collect) {
            String code = ExcelUtil.singleUserProfileToCode((String)s);
            if (!StringUtils.isNotBlank((String)code)) continue;
            joiner.add(code);
        }
        return joiner.toString();
    }

    public static String singleOptToNumber(String optFlag) {
        LatticeOptTypeEnum enumByType = null;
        try {
            Integer.parseInt(optFlag);
            enumByType = LatticeOptTypeEnum.getEnumByType((String)optFlag, (boolean)false);
        }
        catch (NumberFormatException e) {
            enumByType = LatticeOptTypeEnum.getEnumByName((String)optFlag, (boolean)false);
        }
        return enumByType != null ? enumByType.getType() : "";
    }

    public static String singleUserProfileToCode(String userProfile) {
        UserProfileEnum byName = UserProfileEnum.getByName((String)userProfile);
        if (byName != null) {
            return byName.getCode();
        }
        UserProfileEnum byCode = UserProfileEnum.getByCode((String)userProfile);
        if (byCode != null) {
            return byCode.getCode();
        }
        return null;
    }

    public static String optFlagToName(String optFlag) {
        if (StringUtils.isBlank((String)optFlag)) {
            return "";
        }
        if (optFlag.contains(";")) {
            String[] split = optFlag.split(";");
            String text = "";
            for (String s : split) {
                LatticeOptTypeEnum enumByType = LatticeOptTypeEnum.getEnumByType((String)s, (boolean)false);
                text = text + (enumByType == null ? "" : enumByType.getName() + ";");
            }
            if (text.endsWith(";")) {
                text = text.substring(0, text.length() - 1);
            }
            return text;
        }
        LatticeOptTypeEnum enumByType = LatticeOptTypeEnum.getEnumByType((String)optFlag, (boolean)false);
        return enumByType == null ? "" : enumByType.getName();
    }

    public static void addValidationData(Sheet sheet, String[] var1, int colIndex) {
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(1, 1048575, colIndex, colIndex);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint constraint = helper.createExplicitListConstraint(var1);
        DataValidation dataValidation = helper.createValidation(constraint, cellRangeAddressList);
        sheet.addValidationData(dataValidation);
    }

    static {
        LatticeExcelInstructions instructions1 = new LatticeExcelInstructions("\u8868\u5934\u5b57\u6bb5\u542b\u4e49", "");
        LATTICE_EXCEL_INSTRUCTIONS.add(instructions1);
        LatticeExcelInstructions instructions2 = new LatticeExcelInstructions("\u4e09\u6bb5\u7801", "\u4e09\u6bb5\u7801\u7528\u4e8e\u5feb\u4ef6\u7684\u672b\u7aef\u7f51\u7edc\u8282\u70b9\u8def\u5f84\u8bc6\u522b\uff0c\u5e2e\u52a9\u8f6c\u8fd0\u4e2d\u5fc3\u4e0e\u5feb\u9012\u516c\u53f8\u5b9e\u73b0\u6309\u7801\u5206\u8d27\uff0c\u5feb\u901f\u5b9a\u4f4d\uff0c\u652f\u6301\u5feb\u4ef6\u5168\u6d41\u7a0b\u6570\u5b57\u5316\u5206\u62e3\uff1b\u901a\u8fc7\u5bf9\u4e2d\u5fc3\u3001\u5206\u516c\u53f8\u3001\u5206\u90e8\u3001\u672b\u7aef\u4e1a\u52a1\u5458\u53ca\u9a7f\u7ad9\u533a\u57df\u8fdb\u884c\u7f16\u7801\uff0c\u6839\u636e\u5730\u5740\u6240\u5c5e\u7684\u672b\u7aef\u7f51\u7edc\u8282\u70b9\uff0c\u8ba1\u7b97\u4e09\u6bb5\u7801\u5e76\u6253\u5370\u5728\u70ed\u654f\u7eb8\u9762\u5355\u4e0a\u3002\u683c\u5f0f\u901a\u5e38\u4e3aXXX-XXX-XX-XXX\uff08\u6700\u540e\u4e00\u6bb5\u4e3a2\u52303\u4f4d\uff09\uff0c\u5176\u4e2d\uff1a\n\u7b2c\u4e00\u6bb5XXX\u4ee3\u8868\u672b\u7aef\u4e2d\u5fc3\uff0c\u59cb\u53d1\u4e2d\u5fc3\u6839\u636e\u7b2c\u4e00\u6bb5\u7801\u5206\u62e3\u81f3\u5bf9\u5e94\u7684\u672b\u7aef\u4e2d\u5fc3\n\u7b2c\u4e8c\u6bb5XXX-XX\u4ee3\u8868\u672b\u7aef\u6d3e\u4ef6\u7f51\u70b9\uff0c\u672b\u7aef\u4e2d\u5fc3\u6839\u636e\u7b2c\u4e8c\u6bb5\u7801\u5206\u62e3\u81f3\u5bf9\u5bf9\u5e94\u7684\u6d3e\u4ef6\u7f51\u70b9\uff0c\u76ee\u524d\u5206\u516c\u53f8\u4ee5XXX-00\u7f16\u7801\uff0c\u5206\u90e8\u4ee5XXX-01\u300102...99\u7f16\u7801\uff08\u5206\u90e8\u4e0e\u4e0a\u7ea7\u5206\u516c\u53f8\u7684\u524d\u4e09\u4f4d\u4e00\u81f4\uff09\n\u7b2c\u4e09\u6bb5XXX\u6216XX\u4ee3\u8868\u4e1a\u52a1\u5458\u533a\u57df\u6216\u9a7f\u7ad9\uff0c\u672b\u7aef\u7f51\u70b9\u6839\u636e\u7b2c\u4e09\u6bb5\u7801\u8fdb\u884c\u533a\u57df\u6216\u9a7f\u7ad9\u7684\u7ec6\u5206");
        LATTICE_EXCEL_INSTRUCTIONS.add(instructions2);
        LatticeExcelInstructions instructions3 = new LatticeExcelInstructions("\u7ad9\u67dc\u7f16\u7801", "\u7ad9\u67dc\u7684\u7f16\u7801\u6570\u503c");
        LATTICE_EXCEL_INSTRUCTIONS.add(instructions3);
        LatticeExcelInstructions instructions4 = new LatticeExcelInstructions("\u64cd\u4f5c\u7c7b\u578b", "\u64cd\u4f5c\u7c7b\u578b\u5206\u4e3a\uff1a\u4e0d\u751f\u6210\u843d\u683c\u64cd\u4f5c\u8bb0\u5f55\u3001\u5efa\u5305\u3001\u4e0a\u8f66\u3001\u6d3e\u4ef6\u3001\u6d3e\u5165\u5408\u4e00\u3001\u4e0d\u751f\u6210\u4f9b\u4ef6\u4e0e\u843d\u683c\u8bb0\u5f55\u3001\u8fdb\u4ed3\u626b\u63cf");
        LATTICE_EXCEL_INSTRUCTIONS.add(instructions4);
        LatticeExcelInstructions instructions5 = new LatticeExcelInstructions("\u683c\u53e3\u53f7", "\u683c\u53e3\u6570\u503c");
        LATTICE_EXCEL_INSTRUCTIONS.add(instructions5);
        LatticeExcelInstructions instructions6 = new LatticeExcelInstructions("\u4e09\u6bb5\u7801\u5f55\u5165\u8bf4\u660e:", "\u4e09\u6bb5\u7801\u5fc5\u586b,\u82e5\u4e09\u6bb5\u7801\u76f8\u540c\u65f6\u5219\u7ad9\u67dc\u7f16\u7801\u4e0d\u80fd\u76f8\u540c\uff0c\u4e8c\u8005\u90fd\u914d\u7f6e\u65f6\u683c\u53e3\u65e2\u53ef\u4ee5\u6309\u7167\u4e09\u6bb5\u7801\u843d\u683c\u53c8\u53ef\u4ee5\u6309\u7167\u7ad9\u67dc\u7f16\u7801\u843d\u683c");
        LATTICE_EXCEL_INSTRUCTIONS.add(instructions6);
        LatticeExcelInstructions instructions7 = new LatticeExcelInstructions("\u683c\u53e3\u53f7\u5f55\u5165\u8bf4\u660e:", "\u5fc5\u586b\u4e14\u4e09\u4f4d\u6570\u5b57\u7f16\u53f7,\u591a\u4e2a\u683c\u53e3\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00");
        LATTICE_EXCEL_INSTRUCTIONS.add(instructions7);
        LatticeExcelInstructions instructions8 = new LatticeExcelInstructions("\u5907\u6ce8:", "\u9632\u6b62\u6570\u636e\u9519\u8bef\uff0cexcel\u6570\u636e\u683c\u5f0f\u8bf7\u4f7f\u7528\u6587\u672c\u683c\u5f0f");
        LATTICE_EXCEL_INSTRUCTIONS.add(instructions8);
        REQUIRED_LATTICE_HEAD = Arrays.asList("\u683c\u53e3\u540d\u79f0", "\u4e09\u6bb5\u7801", "\u9001\u8d27\u70b9\u540d\u79f0", "\u7ad9\u67dc\u7f16\u7801", "\u64cd\u4f5c\u7c7b\u578b", "\u683c\u53e3\u53f7", "\u76ee\u7684\u5730\u4ee3\u7801", "\u4e1a\u52a1\u5458\u7f16\u53f7", "\u662f\u5426\u751f\u6210\u59cb\u53d1\u7aef\u9000\u56de\u626b\u63cf", "\u7528\u6237\u6807\u7b7e");
        REQUIRED_ENDLINE_LATTICE_HEAD = Arrays.asList("\u683c\u53e3\u540d\u79f0", "\u4e09\u6bb5\u7801", "\u64cd\u4f5c\u7c7b\u578b", "\u683c\u53e3\u53f7", "\u76ee\u7684\u5730\u4ee3\u7801", "\u672b\u7aef\u56de\u6d41");
        REQUIRED_UNLOAD_WITH_DISPATCH_HEAD = Arrays.asList("\u4e09\u6bb5\u7801", "\u76ee\u7684\u5730\u4ee3\u7801", "\u64cd\u4f5c\u7c7b\u578b", "\u4e1a\u52a1\u5458\u7f16\u53f7", "\u662f\u5426\u4ee3\u6d3e\u4ef6");
        HEAD_VALIDATOR_CROSSBELT_LATTICE = headMap -> {
            for (String headName : REQUIRED_LATTICE_HEAD) {
                boolean exist = false;
                for (String value : headMap.values()) {
                    if (!value.startsWith(headName)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                throw new ImportExcelException("Excel\u7f3a\u5c11\u5217\uff1a" + headName + "\uff0c\u8bf7\u4e0b\u8f7d\u6a21\u677f\u67e5\u770b\u793a\u4f8b");
            }
        };
        HEAD_VALIDATOR_UNLOAD_WITH_DISPATCH = headMap -> {
            for (String headName : REQUIRED_UNLOAD_WITH_DISPATCH_HEAD) {
                if (headMap.containsValue(headName)) continue;
                throw new ImportExcelException("Excel\u7f3a\u5c11\u5217\uff1a" + headName + "\uff0c\u8bf7\u4e0b\u8f7d\u6a21\u677f\u67e5\u770b\u793a\u4f8b");
            }
        };
        HEAD_VALIDATOR_ENDLINE_LATTICE = headMap -> {
            for (String headName : REQUIRED_ENDLINE_LATTICE_HEAD) {
                boolean exist = false;
                for (String value : headMap.values()) {
                    if (!headName.equals(value)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                throw new ImportExcelException("Excel\u7f3a\u5c11\u5217\uff1a" + headName + "\uff0c\u8bf7\u4e0b\u8f7d\u6a21\u677f\u67e5\u770b\u793a\u4f8b");
            }
        };
        REQUIRED_LATTICE_DETAIL2 = Arrays.asList("\u5206\u62e3\u7ef4\u5ea6", "\u4e1a\u52a1\u5458\u5de5\u53f7", "\u7ec4\u7ec7\u4ee3\u7801", "\u5ba2\u6237\u7f16\u7801", "\u5e97\u94fa\u7f16\u7801", "\u683c\u53e3\u53f7", "\u76ee\u7684\u5730\u4ee3\u7801", "\u6d3e\u4ef6\u4e1a\u52a1\u5458\u5de5\u53f7");
        REQUIRED_LATTICE_DETAIL2_CENTER = Arrays.asList("\u4e09\u6bb5\u7801", "\u683c\u53e3\u53f7", "\u76ee\u7684\u5730\u4ee3\u7801");
        HEAD_VALIDATOR_LATTICE_DETAIL2 = headMap -> {
            for (String headName : REQUIRED_LATTICE_DETAIL2) {
                boolean exist = false;
                for (String value : headMap.values()) {
                    if (!headName.equals(value)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                throw new ImportExcelException("Excel\u7f3a\u5c11\u5217\uff1a" + headName + "\uff0c\u8bf7\u67e5\u770b\u793a\u4f8b\u56fe");
            }
        };
        HEAD_VALIDATOR_LATTICE_DETAIL2_CENTER = headMap -> {
            for (String headName : REQUIRED_LATTICE_DETAIL2_CENTER) {
                boolean exist = false;
                for (String value : headMap.values()) {
                    if (!headName.equals(value)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                throw new ImportExcelException("Excel\u7f3a\u5c11\u5217\uff1a" + headName + "\uff0c\u8bf7\u67e5\u770b\u793a\u4f8b\u56fe");
            }
        };
        REQUIRED_LATTICE_DETAIL3 = Arrays.asList("\u4e09\u6bb5\u7801", "\u683c\u53e3\u53f7", "\u64cd\u4f5c\u7c7b\u578b", "\u76ee\u7684\u5730\u4ee3\u7801", "\u6d3e\u4ef6\u4e1a\u52a1\u5458\u5de5\u53f7", "\u662f\u5426\u4ee3\u6d3e\u4ef6");
        REQUIRED_WEIGHT_SORTING = Arrays.asList("\u4e09\u6bb5\u7801", "\u683c\u53e3\u53f7");
        HEAD_VALIDATOR_LATTICE_DETAIL3 = headMap -> {
            for (String headName : REQUIRED_LATTICE_DETAIL3) {
                boolean exist = false;
                for (String value : headMap.values()) {
                    if (!value.startsWith(headName)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                throw new ImportExcelException("Excel\u7f3a\u5c11\u5217\uff1a" + headName + "\uff0c\u8bf7\u67e5\u770b\u793a\u4f8b\u56fe");
            }
        };
        HEAD_VALIDATOR_WEIGHT_SORTING = headMap -> {
            for (String headName : REQUIRED_WEIGHT_SORTING) {
                boolean exist = false;
                for (String value : headMap.values()) {
                    if (!headName.equals(value)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                throw new ImportExcelException("Excel\u7f3a\u5c11\u5217\uff1a" + headName + "\uff0c\u8bf7\u67e5\u770b\u793a\u4f8b\u56fe");
            }
        };
        BODY_VALIDATOR_CROSSBELT_LATTICE = rowData -> {
            if (StringUtils.isBlank((String)rowData.getThreeCode())) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u4e09\u6bb5\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((String)rowData.getOptFlag()) && !rowData.getOptFlag().matches("^[\\u4e00-\\u9fa50-9;]+$")) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u64cd\u4f5c\u7c7b\u578b\u53ea\u80fd\u8f93\u5165\u6587\u5b57\u3001\u6570\u5b57\u3001\u82f1\u6587\u5206\u53f7");
            }
            if (StringUtils.isBlank((String)rowData.getLatticeNo())) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u683c\u53e3\u53f7\u4e3a\u7a7a");
            }
            if (!rowData.getLatticeNo().matches("^[0-9;,]+$")) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u683c\u53e3\u53f7\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u3001\u82f1\u6587\u5206\u53f7\u3001\u82f1\u6587\u9017\u53f7");
            }
            if (StringUtils.isBlank((String)rowData.getStatus())) {
                rowData.setStatus(LatticeStatusEnum.ENABLE.getStatusStr());
            }
            if (StringUtils.isBlank((String)rowData.getOptFlag())) {
                rowData.setOptFlag(LatticeOptTypeEnum.NORMAL.getType());
            }
            if ("-1014".equals(rowData.getThreeCode())) {
                if (StringUtils.isBlank((String)rowData.getUserProfile())) {
                    rowData.setUserProfile(UserProfileEnum.getAllCodeStr());
                } else {
                    StringJoiner joiner = new StringJoiner(",");
                    List collect = Arrays.stream(rowData.getUserProfile().split(",|\uff0c")).distinct().collect(Collectors.toList());
                    for (String s : collect) {
                        String code = ExcelUtil.singleUserProfileToCode((String)s);
                        if (StringUtils.isBlank((String)code)) {
                            throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u7528\u6237\u6807\u7b7e\u586b\u5199\u9519\u8bef\uff1a" + s);
                        }
                        joiner.add(code);
                    }
                    rowData.setUserProfile(joiner.toString());
                }
            }
            if (!ExcelUtil.checkOptGroup((String)rowData.getOptFlag(), (String)rowData.getLatticeNo())) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u64cd\u4f5c\u7c7b\u578b\u548c\u683c\u53e3\u53f7\u5206\u7ec4\u4e0d\u4e00\u81f4\uff0c\u5206\u7ec4\u4f7f\u7528\u82f1\u6587\u5206\u53f7\u5206\u9694");
            }
        };
        BODY_VALIDATOR_UNLOAD_WITH_DISPATCH = rowData -> {
            if (StringUtils.isBlank((String)rowData.getOptFlag())) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
            }
            BaseResp baseResp = ExcelUtil.allowOptCheck(Arrays.asList(LatticeOptTypeEnum.UPLOAD, LatticeOptTypeEnum.DISPATCH, LatticeOptTypeEnum.COUNTRY_STATION), (String)rowData.getOptFlag());
            if (!"000".equals(baseResp.getCode())) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u64cd\u4f5c\u7c7b\u578b\u53ea\u80fd\u8f93\u5165" + LatticeOptTypeEnum.UPLOAD.getName() + "\u3001" + LatticeOptTypeEnum.DISPATCH.getName() + "\u3001" + LatticeOptTypeEnum.COUNTRY_STATION.getName() + "\uff08\u4e09\u9009\u4e00\uff09");
            }
        };
        BODY_VALIDATOR_ENDLINE_LATTICE = rowData -> {
            BaseResp baseResp;
            rowData.setLatticeNo(LatticeUtil.transferLatticeNo((String)rowData.getLatticeNo()));
            String err = LatticeUtil.checkLatticeNo((String)rowData.getLatticeNo(), (boolean)true);
            if (StringUtils.isNotBlank((String)err)) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a" + err);
            }
            if (StringUtils.isBlank((String)rowData.getLatticeName())) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u683c\u53e3\u540d\u79f0\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)rowData.getDestOrgCode())) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u76ee\u7684\u5730\u4ee3\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)rowData.getOptFlag())) {
                rowData.setOptFlag(LatticeOptTypeEnum.NORMAL.getType());
            }
            if (!"000".equals((baseResp = ExcelUtil.allowOptCheck(Arrays.asList(LatticeOptTypeEnum.NORMAL, LatticeOptTypeEnum.UPLOAD), (String)rowData.getOptFlag())).getCode())) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u64cd\u4f5c\u7c7b\u578b\u53ea\u80fd\u8f93\u5165\u4e0d\u751f\u6210\u843d\u683c\u3001\u4e0a\u8f66\uff08\u4e8c\u9009\u4e00\uff09");
            }
            if (!LatticeUtil.threeCodeCheck((String)rowData.getThreeCode(), (boolean)false, (boolean)LatticeUtil.threeCodeNeedCheck((String)AutoDeviceTypeEnum.END_LINE.getType(), (String)rowData.getOptFlag()))) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u4e09\u6bb5\u7801\u683c\u5f0f\u9519\u8bef");
            }
            if (!rowData.getLatticeNo().matches("^[0-9,]+$")) {
                throw new ImportExcelException("\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\u6821\u9a8c\u7ed3\u679c\uff1a\u683c\u53e3\u53f7\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u3001\u82f1\u6587\u9017\u53f7");
            }
        };
        BODY_VALIDATOR_LATTICE_DETAIL1 = rowData -> {
            String latticeNoRegex = "^[0-9,]+$";
            if (!rowData.getLatticeNo().matches(latticeNoRegex)) {
                throw new ImportExcelException("\u683c\u53e3\u53f7\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u3001\u82f1\u6587\u9017\u53f7");
            }
            String optFlag = rowData.getOptFlag();
            if (StringUtils.isBlank((String)optFlag)) {
                throw new ImportExcelException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!LatticeOptTypeEnum.NO_TRACKS.getType().equals(optFlag) && !LatticeOptTypeEnum.STARTING_POINT_RETURN_SCAN.getType().equals(optFlag)) {
                throw new ImportExcelException("\u64cd\u4f5c\u7c7b\u578b\u53ea\u80fd\u586b7(\u53ea\u5206\u62e3\u4e0d\u751f\u6210\u8f68\u8ff9)\u30019(\u59cb\u53d1\u7aef\u9000\u56de\u626b\u63cf)");
            }
        };
        BODY_VALIDATOR_LATTICE_DETAIL2 = rowData -> {
            String lineText = "\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\uff1a";
            String latticeNoRegex = "^[0-9,]+$";
            if (StringUtils.isBlank((String)rowData.getLatticeNo())) {
                throw new ImportExcelException(lineText + "\u683c\u53e3\u53f7\u4e3a\u7a7a\uff01");
            }
            if (!rowData.getLatticeNo().matches(latticeNoRegex)) {
                throw new ImportExcelException(lineText + "\u683c\u53e3\u53f7\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u3001\u82f1\u6587\u9017\u53f7");
            }
            if (StringUtils.isBlank((String)rowData.getSortingType())) {
                throw new ImportExcelException(lineText + "\u5206\u62e3\u7ef4\u5ea6\u672a\u586b\u5199");
            }
            if (!(SortingTypeEnum.EMP.getType().equals(rowData.getSortingType()) || SortingTypeEnum.ORG.getType().equals(rowData.getSortingType()) || SortingTypeEnum.CUSTOMER.getType().equals(rowData.getSortingType()))) {
                throw new ImportExcelException(lineText + "\u5206\u62e3\u7ef4\u5ea6\u53ea\u80fd\u586b1\u30012\u30013\uff0c\u8bf7\u67e5\u770b\u793a\u4f8b\u56fe");
            }
        };
        BODY_VALIDATOR_LATTICE_DETAIL2_CENTER = rowData -> {
            String lineText = "\u7b2c" + (rowData.getRowIndex() + 1) + "\u884c\uff1a";
            String latticeNoRegex = "^[0-9,]+$";
            if (StringUtils.isBlank((String)rowData.getLatticeNo())) {
                throw new ImportExcelException(lineText + "\u683c\u53e3\u53f7\u4e3a\u7a7a\uff01");
            }
            if (!rowData.getLatticeNo().matches(latticeNoRegex)) {
                throw new ImportExcelException(lineText + "\u683c\u53e3\u53f7\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u3001\u82f1\u6587\u9017\u53f7");
            }
            rowData.setLatticeNo(LatticeUtil.transferLatticeNo((String)rowData.getLatticeNo()));
            String s = LatticeUtil.checkLatticeNo((String)rowData.getLatticeNo(), (boolean)true);
            if (StringUtils.isNotBlank((String)s)) {
                throw new ImportExcelException(lineText + s);
            }
            if (StringUtils.isBlank((String)rowData.getThreeCode())) {
                throw new ImportExcelException("\u4e09\u6bb5\u7801\u672a\u586b\u5199");
            }
            rowData.setSortingType(SortingTypeEnum.THREE_CODE.getType());
        };
        LATTICE_DETAIL1_HEAD = new /* Unavailable Anonymous Inner Class!! */;
    }
}

