/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.jar;

import cn.yto.jar.InternalUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public final class HttpUtils {
    private static final Integer HTTP_CONN_TIMEOUT = 6000;
    private static final Integer HTTP_SOCKET_TIMEOUT = 6000;

    public static String doPost(String reqUrl, Map<String, Object> parameters) {
        return HttpUtils.doPost(reqUrl, parameters, "UTF-8", HTTP_CONN_TIMEOUT, HTTP_SOCKET_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String reqUrl, Map<String, Object> parameters, String encoding, int connectTimeout, int readTimeout) {
        HttpURLConnection urlConn = null;
        try {
            urlConn = HttpUtils.sendPost(reqUrl, parameters, encoding, connectTimeout, readTimeout);
            String responseContent = HttpUtils.getContent(urlConn, encoding);
            String string = responseContent.trim();
            return string;
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
                urlConn = null;
            }
        }
    }

    private static HttpURLConnection sendPost(String reqUrl, Map<String, Object> parameters, String encoding, int connectTimeout, int readTimeout) {
        HttpURLConnection urlConn = null;
        try {
            String params = InternalUtils.hashMapToJson((HashMap)parameters);
            URL url = new URL(reqUrl);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestProperty("Content-Type", "application/json");
            urlConn.setRequestMethod("POST");
            urlConn.setConnectTimeout(connectTimeout);
            urlConn.setReadTimeout(readTimeout);
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            byte[] b = params.getBytes(encoding);
            urlConn.getOutputStream().write(b, 0, b.length);
            urlConn.getOutputStream().flush();
            urlConn.getOutputStream().close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return urlConn;
    }

    private static String getContent(HttpURLConnection urlConn, String encoding) {
        try {
            String responseContent = null;
            InputStream in = urlConn.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(in, encoding));
            String tempLine = rd.readLine();
            StringBuffer tempStr = new StringBuffer();
            String crlf = System.getProperty("line.separator");
            while (tempLine != null) {
                tempStr.append(tempLine);
                tempStr.append(crlf);
                tempLine = rd.readLine();
            }
            responseContent = tempStr.toString();
            rd.close();
            in.close();
            return responseContent;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

