/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.jar;

import cn.yto.jar.HttpUtils;
import cn.yto.jar.InternalUtils;
import cn.yto.jar.NetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class JarSupport
implements EnvironmentAware {
    private static final byte[] JAR_MAGIC = new byte[]{80, 75, 3, 4};
    private Environment environment;

    @PostConstruct
    protected void init() {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
        scheduler.setKeepAliveTime(7L, TimeUnit.MINUTES);
        scheduler.allowCoreThreadTimeOut(true);
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                JarSupport.this.processAllFrameworkJarList();
            }
        }, 5L, TimeUnit.MINUTES);
    }

    public void processAllFrameworkJarList() {
        try {
            HashMap jarVersionMap = new HashMap();
            List<String> jarList = this.getAllFrameworkJarList();
            for (String jarVersionName : jarList) {
                String[] jarNameAndVersion = this.splitJarNameAndVersion(jarVersionName);
                if (jarNameAndVersion[0] == null || jarNameAndVersion[1] == null) continue;
                if (!jarVersionMap.containsKey(jarNameAndVersion[0])) {
                    jarVersionMap.put(jarNameAndVersion[0], new HashSet());
                }
                ((Set)jarVersionMap.get(jarNameAndVersion[0])).add(jarNameAndVersion[1]);
            }
            if (jarVersionMap.size() > 0) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("appName", this.getApplicationName());
                parameters.put("ip", NetUtils.getLocalHost());
                String port = this.getPortFromEnvironment();
                parameters.put("port", !StringUtils.isEmpty((Object)port) ? port : NetUtils.getLocalPort());
                parameters.put("remark", jarVersionMap);
                parameters.put("pid", String.valueOf(InternalUtils.getPid()));
                String url = "http://monitor-app-api-inter.yto56.com.cn:8889/frame/pushEvent";
                HttpUtils.doPost(url, parameters);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private List<String> getAllFrameworkJarList() {
        ArrayList<String> names = new ArrayList<String>();
        List<URL> classLoaderUrls = this.getAllFrameworkUrlList();
        for (URL url : classLoaderUrls) {
            try {
                if (!this.isJar(url)) continue;
                names.add(url.toString());
            }
            catch (Throwable e) {}
        }
        return names;
    }

    private List<URL> getAllFrameworkUrlList() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            this.getResources(urlList, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return urlList;
    }

    private String[] splitJarNameAndVersion(String jarVersionName) {
        String[] result = new String[2];
        try {
            String[] arrayTemp;
            String tempJarVersionName = jarVersionName.substring(jarVersionName.lastIndexOf("lib") + 4);
            tempJarVersionName = tempJarVersionName.substring(0, tempJarVersionName.lastIndexOf(".jar"));
            int splitIndex = this.getSplitIndex(tempJarVersionName);
            if (tempJarVersionName.contains("javax.annotation-api") || tempJarVersionName.contains("javax.inject")) {
                splitIndex = tempJarVersionName.lastIndexOf("-") + 1;
            }
            String jarName = tempJarVersionName.substring(0, splitIndex - 1);
            String version = tempJarVersionName.substring(splitIndex);
            result[0] = jarName;
            result[1] = version;
            if (jarName.contains("apache-tomcat") && (arrayTemp = version.split("/")) != null && arrayTemp.length == 3) {
                result[0] = arrayTemp[2];
                result[1] = arrayTemp[0];
            }
            if (jarName.contains("jvm/java")) {
                result[0] = null;
                result[1] = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private int getSplitIndex(String jarVersion) {
        int oneIndex = jarVersion.indexOf(".");
        jarVersion = jarVersion.substring(0, oneIndex);
        int twoIndex = jarVersion.lastIndexOf("-");
        return twoIndex + 1;
    }

    private boolean isJar(URL url) {
        if (url.toString().indexOf(".jar") > 0) {
            return true;
        }
        return this.isJar(url, new byte[JAR_MAGIC.length]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJar(URL url, byte[] buffer) {
        InputStream is = null;
        try {
            is = url.openStream();
            is.read(buffer, 0, JAR_MAGIC.length);
            if (Arrays.equals(buffer, JAR_MAGIC)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private void getResources(List<URL> urls, ClassLoader classLoader) throws IOException {
        URL[] lists;
        if (classLoader instanceof URLClassLoader && (lists = ((URLClassLoader)classLoader).getURLs()) != null && lists.length > 0) {
            for (URL url : lists) {
                urls.add(url);
            }
        }
        if (classLoader.getParent() != null) {
            this.getResources(urls, classLoader.getParent());
        }
    }

    private String getUserDir() {
        return System.getProperty("user.dir");
    }

    private String getApplicationName() {
        String appName = this.environment.getProperty("spring.application.name");
        if (!StringUtils.isEmpty((Object)appName)) {
            return appName;
        }
        String contextPath = this.getContextPath();
        if (!StringUtils.isEmpty((Object)contextPath)) {
            return contextPath;
        }
        return this.getUserDir();
    }

    private String getContextPath() {
        String contextPath = "";
        if (this.environment != null && !StringUtils.isEmpty((Object)(contextPath = this.environment.getProperty("server.servlet.context-path")))) {
            contextPath = contextPath.replace("/", "");
        }
        return contextPath;
    }

    private String getPortFromEnvironment() {
        return this.environment.getProperty("server.port");
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

