/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.base.exception.TypeMismatchException;
import cn.yto.utils.EmptyUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanMap;

public final class BeanUtil {
    private BeanUtil() {
    }

    public static <T> T copy(Object source, Class<T> clazz) {
        if (EmptyUtils.isEmpty(source)) {
            return null;
        }
        T target = BeanUtil.instantiate(clazz);
        BeanCopier copier = BeanCopier.create(source.getClass(), clazz, (boolean)false);
        copier.copy(source, target, null);
        return target;
    }

    public static void copy(Object source, Object target) {
        if (EmptyUtils.isEmpty(source) || EmptyUtils.isEmpty(target)) {
            return;
        }
        BeanCopier copier = BeanCopier.create(source.getClass(), target.getClass(), (boolean)false);
        copier.copy(source, target, null);
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        HashMap map = Maps.newHashMap();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(key + "", beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> Map<String, Object> beanToMap(T bean, Boolean ignoreMap) {
        HashMap map = Maps.newHashMap();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                if (null == beanMap.get(key) || ignoreMap.booleanValue() && Map.class.isAssignableFrom(beanMap.get(key).getClass())) continue;
                map.put(key + "", beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> List<T> copyByList(List<?> datas, Class<T> clazz) {
        if (datas == null) {
            return null;
        }
        if (EmptyUtils.isEmpty(datas)) {
            return new ArrayList(0);
        }
        ArrayList<T> result = new ArrayList<T>(datas.size());
        for (Object data : datas) {
            result.add(BeanUtil.copy(data, clazz));
        }
        return result;
    }

    public static <T> T instantiate(Class<T> clazz) throws RuntimeException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new TypeMismatchException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new TypeMismatchException((Throwable)ex);
        }
    }
}

