/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DateUtil {
    private static final Log LOG = LogFactory.getLog(DateUtil.class);

    private DateUtil() {
    }

    public static String formatDate(Date date, String formatPattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatPattern);
        return sdf.format(date);
    }

    public static Date getDateFromString(String value) {
        return DateUtil.getDateFromString(value, Locale.getDefault());
    }

    public static Date getDateFromString(String value, Locale locale) {
        Date result = null;
        DateFormat[] dfs = DateUtil.getDateFormats(locale);
        DateFormat df = null;
        for (DateFormat df1 : dfs) {
            try {
                result = df1.parse(value);
                df = df1;
                if (result == null) continue;
                break;
            }
            catch (ParseException ignore) {
                LOG.error((Object)ignore.getMessage(), (Throwable)ignore);
            }
        }
        if (df == null) {
            df = DateFormat.getDateInstance(3, locale);
        }
        try {
            df.setLenient(false);
            result = df.parse(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static DateFormat[] getDateFormats(Locale locale) {
        DateFormat dt2 = DateFormat.getDateTimeInstance(3, 2, locale);
        DateFormat dt3 = DateFormat.getDateTimeInstance(3, 3, locale);
        DateFormat d1 = DateFormat.getDateInstance(3, locale);
        DateFormat d2 = DateFormat.getDateInstance(2, locale);
        DateFormat d3 = DateFormat.getDateInstance(1, locale);
        SimpleDateFormat d4 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat rfc3399 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        SimpleDateFormat dt4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DateFormat[] dfs = new DateFormat[]{dt2, dt3, rfc3399, dt4, d1, d2, d3, d4};
        return dfs;
    }

    public static XMLGregorianCalendar convertToXMLGregorianCalendar(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        XMLGregorianCalendar gc = null;
        try {
            gc = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return gc;
    }

    public static Date convertToDate(XMLGregorianCalendar cal) throws Exception {
        GregorianCalendar ca = cal.toGregorianCalendar();
        return ca.getTime();
    }
}

