/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.apache.commons.lang3.StringUtils;

public class FastJsonUtil {
    private static final SerializeConfig SERIALIZE_CONFIG = new SerializeConfig();

    public static String toJsonString(Object obj) {
        return FastJsonUtil.toJsonString(obj, true);
    }

    public static String toJsonString(Object obj, boolean seralizerClass) {
        if (obj != null) {
            if (obj instanceof String && StringUtils.isBlank((CharSequence)((String)obj))) {
                return "";
            }
            try {
                if (seralizerClass) {
                    return JSON.toJSONString((Object)obj, (SerializeConfig)SERIALIZE_CONFIG, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
                }
                return JSON.toJSONString((Object)obj, (SerializeConfig)SERIALIZE_CONFIG, (SerializerFeature[])new SerializerFeature[0]);
            }
            catch (Exception e) {
                return "null";
            }
        }
        return "null";
    }

    public static Object jsonParseObject(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return "";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)json, (CharSequence)"null")) {
            return null;
        }
        return JSON.parse((String)json);
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        if ("null".equalsIgnoreCase(json)) {
            return null;
        }
        return (T)JSON.parseObject((String)json, clazz);
    }
}

