/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.commons.lang3.StringUtils;

public abstract class JsonUtil {
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectMapper mapperInclusion = new ObjectMapper();

    public static <T> T parseJson(String json, Class<?> parametrized, Class<?> ... parameterClasses) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        JsonRootName jsonRootName = parametrized.getAnnotation(JsonRootName.class);
        if (jsonRootName != null) {
            mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        } else {
            mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        try {
            JavaType jt = mapper.getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
            return (T)mapper.readValue(json, jt);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T parseJson(String json, Class<?> parametrized) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        JsonRootName jsonRootName = parametrized.getAnnotation(JsonRootName.class);
        if (jsonRootName != null) {
            mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        } else {
            mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        try {
            return (T)mapper.readValue(json, parametrized);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        JsonRootName jsonRootName = obj.getClass().getAnnotation(JsonRootName.class);
        if (jsonRootName != null) {
            mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        } else {
            mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String toJsonInclusion(Object obj) {
        if (obj == null) {
            return null;
        }
        JsonRootName jsonRootName = obj.getClass().getAnnotation(JsonRootName.class);
        if (jsonRootName != null) {
            mapperInclusion.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        } else {
            mapperInclusion.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        try {
            return mapperInclusion.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        mapperInclusion.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

