/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.utils.StringUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class PinYinUtil {
    public static Map<String, String> dictionary = new HashMap<String, String>();
    public static String specific = "[^a-zA-Z\\d_]";
    private static PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public static String[] chineseToPinYin(char chineseCharacter) {
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        outputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        outputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        if (chineseCharacter >= ' ' && chineseCharacter <= '}') {
            return new String[]{String.valueOf(chineseCharacter)};
        }
        try {
            return PinyinHelper.toHanyuPinyinStringArray((char)chineseCharacter, (HanyuPinyinOutputFormat)outputFormat);
        }
        catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
            badHanyuPinyinOutputFormatCombination.printStackTrace();
            return new String[0];
        }
    }

    public static String chineseToPinYinF(String chineseCharacter) {
        if (StringUtil.isBlank(chineseCharacter)) {
            return "";
        }
        char[] chs = chineseCharacter.toCharArray();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < chs.length; ++i) {
            String[] arr = PinYinUtil.chineseToPinYin(chs[i]);
            if (arr == null || arr.length == 0) continue;
            if (arr.length == 1) {
                result.append(arr[0]);
                continue;
            }
            if (arr[0].equals(arr[1])) {
                result.append(arr[0]);
                continue;
            }
            String prim = chineseCharacter.substring(i, i + 1);
            String lst = null;
            String rst = null;
            if (i <= chineseCharacter.length() - 2) {
                rst = chineseCharacter.substring(i, i + 2);
            }
            if (i >= 1 && i + 1 <= chineseCharacter.length()) {
                lst = chineseCharacter.substring(i - 1, i + 1);
            }
            String answer = null;
            for (String py : arr) {
                if (StringUtil.isBlank(py)) continue;
                if (lst != null && py.equals(dictionary.get(lst)) || rst != null && py.equals(dictionary.get(rst))) {
                    answer = py;
                    break;
                }
                if (!py.equals(dictionary.get(prim))) continue;
                answer = py;
            }
            if (answer == null) continue;
            result.append(answer);
        }
        String newResult = result.toString().toUpperCase();
        return newResult.replaceAll(specific, "");
    }

    public static String chineseToPinYinS(String chineseCharacter) {
        if (StringUtil.isBlank(chineseCharacter)) {
            return "";
        }
        char[] chs = chineseCharacter.toCharArray();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < chs.length; ++i) {
            String[] arr = PinYinUtil.chineseToPinYin(chs[i]);
            if (arr == null || arr.length == 0) continue;
            if (arr.length == 1) {
                result.append(arr[0].charAt(0));
                continue;
            }
            if (arr[0].equals(arr[1])) {
                result.append(arr[0].charAt(0));
                continue;
            }
            String prim = chineseCharacter.substring(i, i + 1);
            String lst = null;
            String rst = null;
            if (i <= chineseCharacter.length() - 2) {
                rst = chineseCharacter.substring(i, i + 2);
            }
            if (i >= 1 && i + 1 <= chineseCharacter.length()) {
                lst = chineseCharacter.substring(i - 1, i + 1);
            }
            String answer = null;
            for (String py : arr) {
                if (StringUtil.isBlank(py)) continue;
                if (lst != null && py.equals(dictionary.get(lst)) || rst != null && py.equals(dictionary.get(rst))) {
                    answer = py;
                    break;
                }
                if (!py.equals(dictionary.get(prim))) continue;
                answer = py;
            }
            if (answer == null) continue;
            result.append(answer.charAt(0));
        }
        String newResult = result.toString().toUpperCase();
        return newResult.replaceAll(specific, "");
    }

    public static void main(String[] args) {
        String str = "\u9057\u5931\u4ef6()@#%&%%!**(#__";
        System.out.println(StringUtil.formatDate("HHmmss"));
        System.out.println(str + " pyf=" + PinYinUtil.chineseToPinYinF(str));
        System.out.println(str + " pys=" + PinYinUtil.chineseToPinYinS(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        BufferedReader br = null;
        InputStream in = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = loader.getResource("duoyinzi_pinyin.txt");
            in = url.openStream();
            try {
                br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] sems;
                String[] arr = line.split("#");
                if (!StringUtil.isNotBlank(arr[1])) continue;
                for (String sem : sems = arr[1].split(" ")) {
                    if (!StringUtil.isNotBlank(sem)) continue;
                    dictionary.put(sem, arr[0]);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

