/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.base.interfaces.IVo;
import cn.yto.base.vo.TreeVo;
import cn.yto.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public final class Tools {
    public static <R, T> R convertEntity(T entity, Function<T, R> fun) {
        return fun.apply(entity);
    }

    public static <R, T> List<R> convertList(List<T> list, Function<T, R> fun) {
        ArrayList<R> newList = new ArrayList<R>();
        if (list != null && list.size() > 0) {
            for (T entity : list) {
                newList.add(fun.apply(entity));
            }
        }
        return newList;
    }

    public static <T extends IVo> List<TreeVo> convertTree(List<T> list, Function<T, TreeVo> fun) {
        return Tools.convertTree(list, fun, null);
    }

    public static <T extends IVo> List<TreeVo> convertTree(List<T> list, Function<T, TreeVo> fun, String code) {
        HashMap<String, TreeVo> treeMap = new HashMap<String, TreeVo>();
        for (IVo item : list) {
            treeMap.put(item.getCode(), fun.apply(item));
        }
        ArrayList<TreeVo> treeList = new ArrayList<TreeVo>();
        for (IVo item : list) {
            TreeVo parentNode;
            String itemCode = item.getCode();
            String parentCode = item.getParentCode();
            TreeVo treeVo = parentNode = StringUtil.isEmpty(parentCode) ? null : (TreeVo)treeMap.get(parentCode);
            if (StringUtil.isEmpty(code)) {
                if (null == parentNode) {
                    treeList.add((TreeVo)treeMap.get(itemCode));
                    continue;
                }
            } else if (code.equals(parentCode)) {
                treeList.add((TreeVo)treeMap.get(itemCode));
                continue;
            }
            parentNode.append((TreeVo)treeMap.get(itemCode));
        }
        return treeList;
    }

    public static <T> boolean some(Function<T, Boolean> fun, T ... list) {
        for (T item : list) {
            try {
                if (!fun.apply(item).booleanValue()) continue;
                return true;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }

    public static <T> boolean every(Function<T, Boolean> fun, T ... list) {
        for (T item : list) {
            try {
                if (fun.apply(item).booleanValue()) continue;
                return false;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }
}

