/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils.ids;

import cn.yto.utils.ids.IdsWorker;
import cn.yto.utils.ids.snowflake.SnowFlakeIdsWorker;
import cn.yto.utils.ids.uuid.UUIdsWorker;

public enum IdsWorkers {
    SNOWFLAKE(SnowFlakeIdsWorker.getWorker()),
    UUID(UUIdsWorker.getWorker()),
    REDIS(null),
    ZOOKEEPER(null);

    private final IdsWorker idsWorker;

    private IdsWorkers(IdsWorker idsWorker) {
        this.idsWorker = idsWorker;
    }

    public String nextId() {
        if (null == this.idsWorker) {
            throw new UnsupportedOperationException("Redis idsWorker only be used by IdsWorkerFactory.");
        }
        return this.idsWorker.nextId();
    }

    public String nextId(String sequence) {
        if (null == this.idsWorker) {
            throw new UnsupportedOperationException("Redis or Zookeeper idsWorker only be used by IdsWorkerFactory.");
        }
        return this.idsWorker.nextId(sequence);
    }
}

