/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils.ids.snowflake;

import cn.yto.utils.ids.IdsWorker;
import java.security.SecureRandom;

public class SnowFlakeIdsWorker
implements IdsWorker {
    private static SnowFlakeIdsWorker idsWorker;
    private final long twepoch = 142004160000000L;
    private final long workerIdBits = 8L;
    private final long datacenterIdBits = 8L;
    private final long maxWorkerId = 255L;
    private final long maxDatacenterId = 255L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long datacenterIdShift = 20L;
    private final long timestampLeftShift = 28L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowFlakeIdsWorker(long workerId, long datacenterId) {
        if (workerId > 255L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 255L));
        }
        if (datacenterId > 255L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 255L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    @Override
    public synchronized String nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return String.valueOf(timestamp - 142004160000000L << 28 | this.datacenterId << 20 | this.workerId << 12 | this.sequence).substring(1);
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 1000; ++i) {
            System.out.println(SnowFlakeIdsWorker.getWorker().nextId());
        }
        System.out.println(SnowFlakeIdsWorker.getWorker().nextId().length());
    }

    @Override
    public String nextId(String sequence) {
        throw new UnsupportedOperationException("Unsupport operation nextId(String sequence) for SnowFlakeIdsWorker.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IdsWorker getWorker() {
        if (idsWorker != null) return idsWorker;
        Class<SnowFlakeIdsWorker> clazz = SnowFlakeIdsWorker.class;
        synchronized (SnowFlakeIdsWorker.class) {
            if (idsWorker != null) return idsWorker;
            SecureRandom sr = new SecureRandom();
            idsWorker = new SnowFlakeIdsWorker(sr.nextInt(256), sr.nextInt(256));
            // ** MonitorExit[var0] (shouldn't be in output)
            return idsWorker;
        }
    }
}

