/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions.query;

import com.baomidou.mybatisplus.core.conditions.AbstractLambdaWrapper;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.baomidou.mybatisplus.core.toolkit.support.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class LambdaQueryWrapper<T>
extends AbstractLambdaWrapper<T, LambdaQueryWrapper<T>> {
    private String predicateSelect;
    private List<String> queryColumn = new ArrayList<String>();
    @Deprecated
    private List<String> excludeColumn = new ArrayList<String>();

    public LambdaQueryWrapper() {
        this(null);
    }

    public LambdaQueryWrapper(T entity) {
        this.entity = entity;
        this.initEntityClass();
        this.initNeed();
    }

    LambdaQueryWrapper(T entity, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments) {
        this.entity = entity;
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.initEntityClass();
    }

    @Override
    public String getSqlSelect() {
        if (StringUtils.isNotEmpty(this.predicateSelect)) {
            return this.predicateSelect;
        }
        if (CollectionUtils.isEmpty(this.queryColumn)) {
            if (this.entityClass != null) {
                this.queryColumn = Arrays.asList(TableInfoHelper.getTableColumns(this.entityClass, this.excludeColumn.toArray(new String[0])));
            }
        } else {
            return SqlUtils.stripSqlInjection(this.queryColumn.stream().filter(i -> !this.excludeColumn.contains(i)).collect(Collectors.joining(",")));
        }
        return CollectionUtils.isEmpty(this.queryColumn) ? null : String.join((CharSequence)",", this.queryColumn);
    }

    @SafeVarargs
    public final LambdaQueryWrapper<T> select(Property<T, ?> ... columns) {
        for (Property<T, ?> column : columns) {
            this.queryColumn.add(this.columnToString(column));
        }
        return (LambdaQueryWrapper)this.typedThis;
    }

    public LambdaQueryWrapper<T> select(Predicate<TableFieldInfo> predicate) {
        return this.select(this.entityClass, predicate);
    }

    public LambdaQueryWrapper<T> select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        this.entityClass = entityClass;
        this.checkEntityClass();
        this.predicateSelect = TableInfoHelper.getTableInfo(entityClass).chooseSelect(predicate);
        return (LambdaQueryWrapper)this.typedThis;
    }

    @Deprecated
    @SafeVarargs
    public final LambdaQueryWrapper<T> excludeColumns(Class<T> entityClass, Property<T, ?> ... excludeColumns) {
        Assert.notEmpty(excludeColumns, "excludeColumns must not empty");
        this.entityClass = entityClass;
        this.checkEntityClass();
        for (Property<T, ?> column : excludeColumns) {
            this.excludeColumn.add(this.columnToString(column));
        }
        return (LambdaQueryWrapper)this.typedThis;
    }

    @SafeVarargs
    @Deprecated
    public final LambdaQueryWrapper<T> excludeColumns(Property<T, ?> ... excludeColumns) {
        this.checkEntityClass();
        return this.excludeColumns(this.entityClass, excludeColumns);
    }

    @Override
    protected LambdaQueryWrapper<T> instance(AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs) {
        return new LambdaQueryWrapper<Object>(this.entity, paramNameSeq, paramNameValuePairs, new MergeSegments());
    }
}

