/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.convert.Converter;
import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.convert.impl.ArrayConverter;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.json.serialize.GlobalSerializeMapping;
import cn.hutool.json.serialize.JSONDeserializer;
import java.lang.reflect.Type;
import java.util.List;

public class JSONConverter
implements Converter<JSON> {
    protected static Object toArray(JSONArray jsonArray, Class<?> arrayClass) {
        return new ArrayConverter(arrayClass).convert(jsonArray, null);
    }

    protected static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        return Convert.toList(elementType, jsonArray);
    }

    protected static <T> T jsonConvert(Type targetType, Object value, boolean ignoreError) throws ConvertException {
        Object targetValue;
        JSONDeserializer<?> deserializer;
        if (JSONUtil.isNull(value)) {
            return null;
        }
        if (value instanceof JSON && null != (deserializer = GlobalSerializeMapping.getDeserializer(targetType))) {
            return (T)deserializer.deserialize((JSON)value);
        }
        Object t = targetValue = ignoreError ? Convert.convertQuietly(targetType, value) : Convert.convert(targetType, value);
        if (null == targetValue && !ignoreError) {
            if (StrUtil.isBlankIfStr(value)) {
                return null;
            }
            throw new ConvertException("Can not convert {} to type {}", value, ObjectUtil.defaultIfNull(TypeUtil.getClass(targetType), targetType));
        }
        return targetValue;
    }

    @Override
    public JSON convert(Object value, JSON defaultValue) throws IllegalArgumentException {
        return JSONUtil.parse(value);
    }

    static {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        registry.putCustom((Type)((Object)JSON.class), (Class<? extends Converter<?>>)JSONConverter.class);
        registry.putCustom((Type)((Object)JSONObject.class), (Class<? extends Converter<?>>)JSONConverter.class);
        registry.putCustom((Type)((Object)JSONArray.class), (Class<? extends Converter<?>>)JSONConverter.class);
    }
}

