/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.supports;

import cn.yto.supports.EnviromentMatcher;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.endpoint.ExposeExcludePropertyEndpointFilter;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@ConditionalOnClass(value={ExposeExcludePropertyEndpointFilter.class})
public class ActuatorSupportPostProcessor
implements BeanPostProcessor,
EnvironmentAware {
    private Environment environment;
    private static final String ENDPOINT_METHOD_NAME = "match";
    private static final String[] INCLUDE_ENDPOINTS = new String[]{"health", "prometheus", "errmsgpoint", "feign"};
    private static final String GET_ENDPOINT_ID = "getEndpointId";
    private static final String GET_ID = "getId";

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ExposeExcludePropertyEndpointFilter) {
            ExposeExcludePropertyEndpointFilter filter = (ExposeExcludePropertyEndpointFilter)bean;
            if (EnviromentMatcher.matchProfile(this.environment)) {
                return Proxy.newProxyInstance(filter.getClass().getClassLoader(), filter.getClass().getInterfaces(), (InvocationHandler)new ActuatorInvocationHandler(filter));
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    class ActuatorInvocationHandler
    implements InvocationHandler {
        private ExposeExcludePropertyEndpointFilter filter;

        public ActuatorInvocationHandler(ExposeExcludePropertyEndpointFilter filter) {
            this.filter = filter;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (ActuatorSupportPostProcessor.ENDPOINT_METHOD_NAME.equals(method.getName())) {
                ExposableEndpoint endpoint = (ExposableEndpoint)args[0];
                if (!Arrays.stream(INCLUDE_ENDPOINTS).anyMatch(e -> {
                    Method method1 = null;
                    try {
                        method1 = endpoint.getClass().getMethod(ActuatorSupportPostProcessor.GET_ENDPOINT_ID, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException1) {
                        try {
                            method1 = endpoint.getClass().getMethod(ActuatorSupportPostProcessor.GET_ID, new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (method1 != null) {
                        try {
                            Object obj = method1.invoke((Object)endpoint, new Object[0]);
                            String eid = obj.toString().toLowerCase();
                            return e.equals(eid);
                        }
                        catch (Exception invocationTargetException) {
                            return false;
                        }
                    }
                    return false;
                })) {
                    return false;
                }
            }
            return method.invoke((Object)this.filter, args);
        }
    }
}

