/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.supports;

import cn.yto.supports.EnviromentMatcher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@ConditionalOnClass(value={ServletRegistrationBean.class})
public class DruidSupportPostProcessor
implements BeanPostProcessor,
EnvironmentAware {
    private Environment environment;
    private static final String DRUID_SWITCH = "spring.datasource.druid.stat-view-servlet.enabled";
    private static final String DRUID_VIEW_NAME = "statViewServletRegistrationBean";

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ServletRegistrationBean) {
            ServletRegistrationBean servletRegistrationBean = (ServletRegistrationBean)bean;
            if (DRUID_VIEW_NAME.equals(beanName) && (EnviromentMatcher.matchProfile(this.environment) || !Boolean.valueOf(this.environment.getProperty(DRUID_SWITCH, Boolean.FALSE.toString())).booleanValue())) {
                servletRegistrationBean.setEnabled(false);
            }
            return servletRegistrationBean;
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

