/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.supports;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import org.springframework.core.env.Environment;

public class EnviromentMatcher {
    private static final String LOCAL_IP = EnviromentMatcher.getHostAddress();
    private static final String YTO_PRD_IP_PREFIX = "10.7.";
    private static final String YTO_PRD1_IP_PREFIX = "10.187.";
    private static final String YTO_PRD2_IP_PREFIX = "10.186.";
    private static final String YTO_PRD3_IP_PREFIX = "10.190.";
    private static final String APOLLO_SWITCH = "apollo.bootstrap.enabled";
    private static final String APOLLO_META_HOST = "apollo-meta-inter.yto56.com.cn";
    private static final String[] MAYBE_PROD_PROFILES = new String[]{"pro", "prd", "prod", "production", "online"};

    public static boolean matchProfile(Environment environment) {
        String[] profiles;
        String apolloMeta;
        if (LOCAL_IP.startsWith(YTO_PRD_IP_PREFIX) || LOCAL_IP.startsWith(YTO_PRD1_IP_PREFIX) || LOCAL_IP.startsWith(YTO_PRD2_IP_PREFIX) || LOCAL_IP.startsWith(YTO_PRD3_IP_PREFIX)) {
            return true;
        }
        if (Boolean.valueOf(environment.getProperty(APOLLO_SWITCH, Boolean.FALSE.toString())).booleanValue() && (apolloMeta = environment.getProperty("apollo.meta", "").toLowerCase()).indexOf(APOLLO_META_HOST) != -1) {
            return true;
        }
        for (String profile : profiles = environment.getActiveProfiles()) {
            String profileLower = profile.toLowerCase();
            boolean matched = Arrays.stream(MAYBE_PROD_PROFILES).anyMatch(ps -> profileLower.indexOf((String)ps) != -1);
            if (!matched) continue;
            return true;
        }
        return false;
    }

    private static String getHostAddress() {
        String address = "127.0.0.1";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                Enumeration<InetAddress> ads = ni.getInetAddresses();
                while (ads.hasMoreElements()) {
                    InetAddress ip = ads.nextElement();
                    if (ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return address;
    }
}

