/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.supports;

import cn.yto.supports.EnviromentMatcher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import springfox.documentation.spring.web.plugins.Docket;

@ConditionalOnClass(value={Docket.class})
public class SwaggerSupportPostProcessor
implements BeanPostProcessor,
EnvironmentAware {
    private Environment environment;
    private static final String SWAGGER_SWITCH = "swagger.enable";

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Docket) {
            Docket docket = (Docket)bean;
            if (EnviromentMatcher.matchProfile(this.environment) || !Boolean.valueOf(this.environment.getProperty(SWAGGER_SWITCH, Boolean.FALSE.toString())).booleanValue()) {
                docket.enable(false);
            }
            return docket;
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

