/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisManager {
    private String host = "127.0.0.1";
    private int port = 6379;
    private int expire = 0;
    private int timeout = 0;
    private String password = "";
    private static JedisPool jedisPool = null;

    public void init() {
        if (jedisPool == null) {
            jedisPool = this.password != null && !"".equals(this.password) ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port, this.timeout, this.password) : (this.timeout != 0 ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port, this.timeout) : new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(byte[] key) {
        byte[] value = null;
        Jedis jedis = (Jedis)jedisPool.getResource();
        try {
            value = jedis.get(key);
        }
        finally {
            jedisPool.returnResource(jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] set(byte[] key, byte[] value) {
        Jedis jedis = (Jedis)jedisPool.getResource();
        try {
            jedis.set(key, value);
            if (this.expire != 0) {
                jedis.expire(key, this.expire);
            }
        }
        finally {
            jedisPool.returnResource(jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] set(byte[] key, byte[] value, int expire) {
        Jedis jedis = (Jedis)jedisPool.getResource();
        try {
            jedis.set(key, value);
            if (expire != 0) {
                jedis.expire(key, expire);
            }
        }
        finally {
            jedisPool.returnResource(jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void del(byte[] key) {
        Jedis jedis = (Jedis)jedisPool.getResource();
        try {
            jedis.del(key);
        }
        finally {
            jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDB() {
        Jedis jedis = (Jedis)jedisPool.getResource();
        try {
            jedis.flushDB();
        }
        finally {
            jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long dbSize() {
        Long dbSize = 0L;
        Jedis jedis = (Jedis)jedisPool.getResource();
        try {
            dbSize = jedis.dbSize();
        }
        finally {
            jedisPool.returnResource(jedis);
        }
        return dbSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<byte[]> keys(String pattern) {
        Set keys = null;
        Jedis jedis = (Jedis)jedisPool.getResource();
        try {
            keys = jedis.keys(pattern.getBytes());
        }
        finally {
            jedisPool.returnResource(jedis);
        }
        return keys;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

