/*
 * Decompiled with CFR 0.152.
 */
package cn.yto;

import cn.yto.cache.IPMacService;
import cn.yto.cache.LatticeCacheService;
import cn.yto.cache.LatticeStatusCacheService;
import cn.yto.cache.OperationTableCacheService;
import cn.yto.config.CameraConfig;
import cn.yto.config.HttpHostsConfig;
import cn.yto.config.SortingConfig;
import cn.yto.config.WcsTcpServerConfig;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.client.manage.NettyClientinitializer;
import cn.yto.netty.server.camera.CameraNettyServer;
import cn.yto.netty.server.plc.PlcNettyServer;
import cn.yto.netty.server.tcp.NettyServer;
import cn.yto.rest.RestClient;
import cn.yto.schedule.CacheRefreshScheduler;
import cn.yto.schedule.SchedulerJobManager;
import cn.yto.service.AppInfoService;
import cn.yto.service.ManageConfigService;
import cn.yto.service.database.WcsDataBaseService;
import cn.yto.utils.CMDUtil;
import cn.yto.utils.ExpUtils;
import cn.yto.utils.HeartBeatTaskThreadUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class SystemCommandLineRunner
implements CommandLineRunner {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Autowired
    private WcsTcpServerConfig wcsTcpServerConfig;
    @Autowired
    private NettyServer nettyServer;
    @Autowired
    private CameraNettyServer cameraNettyServer;
    @Autowired
    private NettyClientinitializer nettyClientinitializer;
    @Autowired
    private WcsDataBaseService wcsDataBaseService;
    @Value(value="${spring.profiles.active:default}")
    private String env;
    @Autowired
    private HttpHostsConfig httpHostsConfig;
    @Autowired
    private SchedulerJobManager schedulerJobManager;
    @Autowired
    private CameraConfig cameraConfig;
    @Autowired
    private LatticeCacheService latticeCacheService;
    @Autowired
    private PlcNettyServer plcNettyServer;
    @Autowired
    private OperationTableCacheService tableCacheService;
    @Autowired
    private SortingConfig sortingConfig;
    @Autowired
    private CacheRefreshScheduler cacheRefreshScheduler;
    @Autowired
    private AppInfoService appInfoService;
    @Autowired
    private LatticeStatusCacheService latticeStatusCacheService;
    @Autowired
    private ManageConfigService manageConfigService;
    @Autowired
    private IPMacService ipMacService;

    public void run(String ... args) {
        boolean canUsePort;
        RestClient.init((Map)this.httpHostsConfig.getHosts());
        logger.info("\u521d\u59cb\u5316\u76d1\u63a7\u6570\u636e\u5e93MYSQL...");
        if ("test".equals(this.env)) {
            this.wcsDataBaseService.initTables("YTO_WCS_TEST");
        } else {
            this.wcsDataBaseService.initTables("YTO_WCS");
        }
        if (this.wcsTcpServerConfig.getWcsStartUpTcpServerChannel() == 1) {
            logger.info("\u5f00\u59cb\u521d\u59cb\u5316Netty TCP\u670d\u52a1\u7aef\u5bf9\u8c61");
            canUsePort = CMDUtil.checkProcessCanUsePort((String)String.valueOf(this.wcsTcpServerConfig.getWcsTcpPort()));
            if (!canUsePort) {
                logger.error("Netty TCP\u670d\u52a1\u7aef\u542f\u52a8\u5931\u8d25," + this.wcsTcpServerConfig.getWcsTcpPort() + "\u7aef\u53e3\u5df2\u7ecf\u88ab\u5360\u7528\uff0c\u8bf7\u8054\u7cfb\u603b\u90e8\u81ea\u52a8\u5316\u8fd0\u7ef4");
                System.exit(0);
                return;
            }
            this.nettyServer.start(this.wcsTcpServerConfig.getWcsTcpPort().intValue());
        }
        if (this.wcsTcpServerConfig.getPlcStartUpChannel() == 1) {
            logger.info("\u5f00\u59cb\u521d\u59cb\u5316Netty TCP\u670d\u52a1\u7aef\u5bf9\u8c61");
            String pid = CMDUtil.getPID((String)String.valueOf(this.wcsTcpServerConfig.getPlcPort()));
            logger.info("pid:{}", (Object)pid);
            if (ExpUtils.isNotBlank((String)pid) && !"0".equals(pid)) {
                logger.error("Netty PLC\u670d\u52a1\u7aef\u542f\u52a8\u5931\u8d25," + this.wcsTcpServerConfig.getPlcPort() + "\u7aef\u53e3\u5df2\u7ecf\u88ab\u5360\u7528\uff0c\u8bf7\u8054\u7cfb\u603b\u90e8\u81ea\u52a8\u5316\u8fd0\u7ef4");
                System.exit(0);
                return;
            }
            this.plcNettyServer.start(this.wcsTcpServerConfig.getPlcPort().intValue());
        }
        if (this.cameraConfig.getCameraStartUpChannel() == 1) {
            logger.info("\u5f00\u59cb\u521d\u59cb\u5316Netty CAMERA\u670d\u52a1\u7aef\u5bf9\u8c61");
            canUsePort = CMDUtil.checkProcessCanUsePort((String)String.valueOf(this.cameraConfig.getCameraPort()));
            if (!canUsePort) {
                logger.error("Netty camera\u670d\u52a1\u7aef\u542f\u52a8\u5931\u8d25," + this.cameraConfig.getCameraPort() + "\u7aef\u53e3\u5df2\u7ecf\u88ab\u5360\u7528\uff0c\u8bf7\u8054\u7cfb\u603b\u90e8\u81ea\u52a8\u5316\u8fd0\u7ef4");
                System.exit(0);
                return;
            }
            this.cameraNettyServer.start(this.cameraConfig.getCameraPort().intValue());
        }
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316Netty\u5ba2\u6237\u7aef\u5bf9\u8c61");
        this.nettyClientinitializer.initNettyClientObj();
        this.appInfoService.systemStartAutoCreateAppInfo();
        this.manageConfigService.refreshManageConfig();
        logger.info("\u542f\u52a8\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1...");
        try {
            this.schedulerJobManager.scheduleAllJobs();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u4e66\u5199\u683c\u5f0f");
            System.exit(0);
            return;
        }
        this.cacheRefreshScheduler.start();
        if (this.sortingConfig.topScan()) {
            this.ipMacService.initIpMacTables();
        }
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u5fc3\u8df3\u4efb\u52a1");
        HeartBeatTaskThreadUtil.start();
    }
}

