/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.controller;

import cn.yto.config.SystemConfig;
import cn.yto.entity.BaseResponse;
import cn.yto.entity.ExpImageUploadInfo;
import cn.yto.entity.HttpBaseResponse;
import cn.yto.mapper.ExpImageUploadInfoMapper;
import cn.yto.service.image.ExpImgUploadService;
import cn.yto.web.common.base.BaseController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"camera"})
public class CameraUtilsController
extends BaseController {
    @Autowired
    private SystemConfig systemConfig;
    @Autowired
    private ExpImageUploadInfoMapper expImageUploadInfoMapper;
    @Autowired
    private ExpImgUploadService expImgUploadService;

    @RequestMapping(value={"/uploadLeaveImg"}, method={RequestMethod.GET, RequestMethod.POST})
    public BaseResponse handLockLeaveTask(@RequestParam(required=false) Map<String, Object> params) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        Integer limit = params.get("limit") == null ? 1000 : (Integer)params.get("limit");
        Integer retryCount = params.get("retryCount") == null ? 3 : (Integer)params.get("retryCount");
        Integer i = params.get("index") == null ? 0 : (Integer)params.get("index");
        String tableName = "T_IMAGE_UPLOAD_INFO_" + i;
        List imageItemList = this.expImageUploadInfoMapper.getSupplmentData(limit.intValue(), retryCount.intValue(), tableName);
        if (CollectionUtils.isEmpty((Collection)imageItemList)) {
            String message = "\u6ca1\u6709\u9700\u8981\u8865\u4f20\u7684\u6570\u636e,\u65e0\u9700\u8fdb\u884c\u8865\u4f20";
            resp.setMsg(message);
            return resp;
        }
        Long startTime = System.currentTimeMillis();
        int successCount = 0;
        int failCount = 0;
        ArrayList<String> failedWaybillNos = new ArrayList<String>();
        for (ExpImageUploadInfo imageItem : imageItemList) {
            HttpBaseResponse result = this.expImgUploadService.handlerSingleSupplyImg(imageItem);
            if ("000".equals(result.getRespCode())) {
                ++successCount;
                continue;
            }
            ++failCount;
            failedWaybillNos.add(imageItem.getWaybillNo());
        }
        String message = "\u672c\u6b21\u8865\u4f20\u7ed3\u675f,\u6210\u529f\u6570\u91cf:" + successCount + ",\u5931\u8d25\u6570\u91cf:" + failCount + ",\u603b\u5171\u8017\u65f6:" + (System.currentTimeMillis() - startTime);
        resp.setMsg(message);
        resp.setData(failedWaybillNos);
        return resp;
    }
}

