/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.yto.cache.IPMacService;
import cn.yto.communication.plc.send.SendLatticeComm;
import cn.yto.config.SortingConfig;
import cn.yto.config.WcsTcpServerConfig;
import cn.yto.constants.LatticeActionEnum;
import cn.yto.constants.MtyEnum;
import cn.yto.entity.BaseResponse;
import cn.yto.entity.ClientHttpResponse;
import cn.yto.entity.ParamQueryAndSetReq;
import cn.yto.entity.ParamQueryAndSetResp;
import cn.yto.entity.ScanReq;
import cn.yto.entity.busigateway.response.AbnormalSupplyRecordReq;
import cn.yto.entity.busigateway.response.DeviceErrorRecordListDataResp;
import cn.yto.entity.busigateway.response.DeviceErrorRecordReq;
import cn.yto.entity.busigateway.response.LatticeQueryData;
import cn.yto.entity.busigateway.response.OptCommonData;
import cn.yto.entity.busigateway.response.SortRecordListDataReq;
import cn.yto.entity.busigateway.response.SortRecordListDataResp;
import cn.yto.entity.busigateway.response.SortRecordSupplmentReq;
import cn.yto.entity.busigateway.response.TcpConfigQureyData;
import cn.yto.entity.busigateway.response.WrongSortQueryReq;
import cn.yto.entity.monitor.CFAnalysisResult;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.plc.PlcGateWay;
import cn.yto.service.AbnormalSupplyService;
import cn.yto.service.DeviceErrorRecordService;
import cn.yto.service.PlcParamService;
import cn.yto.service.ScanCodeService;
import cn.yto.service.devicesort.DeviceSortRecordService;
import cn.yto.service.lattice.LatticeLockService;
import cn.yto.utils.ExpUtils;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OptScanController {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    @Autowired
    private WcsTcpServerConfig wcsTcpServerConfig;
    @Autowired
    private SortingConfig sortingConfig;
    @Autowired
    private ScanCodeService scanCodeService;
    @Autowired
    private DeviceSortRecordService deviceSortRecordService;
    @Autowired
    private DeviceErrorRecordService deviceErrorRecordService;
    @Autowired
    private LatticeLockService latticeLockService;
    @Autowired
    private SendLatticeComm sendLatticeComm;
    @Autowired
    private IPMacService ipMacService;
    @Autowired
    private AbnormalSupplyService abnormalSupplyService;
    @Autowired
    private PlcParamService plcParamService;
    private static final Timer HASHED_WHEEL_TIMER = new HashedWheelTimer((ThreadFactory)new CustomizableThreadFactory("delay-thread"));

    @ApiOperation(value="\u4e91\u8bf7\u6c42", httpMethod="POST", produces="application/json")
    @PostMapping(value={"/process"}, produces={"application/json"})
    public BaseResponse<OptCommonData> optScanProcess(@RequestBody JSONObject json) {
        long start = System.currentTimeMillis();
        String str = json.toJSONString();
        logger.info("\u6536\u5230\u5ba2\u6237\u7aefhttp\u8bf7\u6c42:{}", (Object)str);
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        resp.setMsg("\u6210\u529f");
        String mty = json.getString("mty");
        String servTime = ExpUtils.formatDateTimeMill((Date)new Date());
        OptCommonData commonData = new OptCommonData();
        commonData.setServerTime(servTime);
        if (MtyEnum.SCAN_CODE.getKey().equals(mty)) {
            ScanReq scanReq = (ScanReq)json.toJavaObject(ScanReq.class);
            this.scanCodeService.procScanReq(scanReq);
            commonData.setMty(MtyEnum.SCAN_CODE_RESP.getKey());
            resp.setData((Object)commonData);
        } else if (MtyEnum.TCP_PORT_QUERY.getKey().equals(mty)) {
            TcpConfigQureyData data = new TcpConfigQureyData();
            data.setServerTime(servTime);
            data.setWcsPort(String.valueOf(this.wcsTcpServerConfig.getWcsTcpPort()));
            data.setDynamicScale(String.valueOf(this.sortingConfig.getDynamicScale()));
            data.setLatticeNum(String.valueOf(this.sortingConfig.getLatticeNum()));
            data.setPhysicalLattice(String.valueOf(this.sortingConfig.getPhysicalLattice()));
            data.setWcsIp(this.wcsTcpServerConfig.getWcsIp());
            data.setMty(MtyEnum.TCP_PORT_QUERY_RESP.getKey());
            resp.setData((Object)data);
        } else if (MtyEnum.SORT_RECORD_QUERY.getKey().equals(mty)) {
            SortRecordListDataReq sortRecordListDataReq = (SortRecordListDataReq)json.toJavaObject(SortRecordListDataReq.class);
            List records = new ArrayList();
            SortRecordListDataResp data = new SortRecordListDataResp();
            if (ExpUtils.isNotBlank((String)sortRecordListDataReq.getWaybillNo())) {
                records = this.deviceSortRecordService.selectDeviceSortRecordList(sortRecordListDataReq.getWaybillNo(), sortRecordListDataReq.getRecordType(), null, null);
                data.setPageNum(1);
                data.setPageSize(records.size());
                data.setTotal((long)records.size());
                data.setPages(1);
                data.setList(records);
            } else {
                Integer pageNum = 1;
                Integer pageSize = 10;
                if (Objects.nonNull(sortRecordListDataReq.getPageNum())) {
                    pageNum = Integer.parseInt(sortRecordListDataReq.getPageNum());
                }
                if (Objects.nonNull(sortRecordListDataReq.getPageSize())) {
                    pageSize = Integer.parseInt(sortRecordListDataReq.getPageSize());
                }
                PageInfo result = new PageInfo();
                result = PageHelper.startPage((int)pageNum, (int)pageSize).doSelectPageInfo(() -> this.deviceSortRecordService.selectDeviceRecordByCondition(sortRecordListDataReq));
                data.setPageNum(result.getPageNum());
                data.setPageSize(result.getPageSize());
                data.setTotal(result.getTotal());
                data.setPages(result.getPages());
                data.setList(result.getList());
            }
            data.setServerTime(servTime);
            data.setMty(MtyEnum.SORT_RECORD_QUERY_RESP.getKey());
            resp.setData((Object)data);
        } else if (MtyEnum.SORT_RECORD_SUPPLMENT.getKey().equals(mty)) {
            SortRecordSupplmentReq supplmentReq = (SortRecordSupplmentReq)json.toJavaObject(SortRecordSupplmentReq.class);
            this.deviceSortRecordService.supplmentData(supplmentReq);
            commonData.setMty(MtyEnum.SORT_RECORD_SUPPLMENT_RESP.getKey());
            resp.setData((Object)commonData);
        } else if (MtyEnum.FAULT_QUERY.getKey().equals(mty)) {
            DeviceErrorRecordReq errorRecordReq = (DeviceErrorRecordReq)json.toJavaObject(DeviceErrorRecordReq.class);
            PageInfo recordPageInfo = this.deviceErrorRecordService.selectFaultList(errorRecordReq);
            DeviceErrorRecordListDataResp data = new DeviceErrorRecordListDataResp();
            data.setServerTime(servTime);
            data.setMty(MtyEnum.FAULT_QUERY_RESP.getKey());
            data.setPageNum(recordPageInfo.getPageNum());
            data.setPageSize(recordPageInfo.getPageSize());
            data.setTotal(recordPageInfo.getTotal());
            data.setList(recordPageInfo.getList());
            resp.setData((Object)data);
        } else if (MtyEnum.LATTICE_STATUS_QUERY.getKey().equals(mty)) {
            LatticeQueryData queryData = (LatticeQueryData)json.toJavaObject(LatticeQueryData.class);
            boolean needUploadFull = false;
            if (LatticeActionEnum.ALL_LATTICE_STATUS.getKey().equals(queryData.getType())) {
                needUploadFull = true;
            } else if (LatticeActionEnum.ALL_LATTICE_LOCK.getKey().equals(queryData.getType())) {
                this.sendLatticeComm.sendPlcLatticeCmd(String.valueOf(0), "1");
                needUploadFull = true;
            } else if (LatticeActionEnum.ALL_LATTICE_UNLOCK.getKey().equals(queryData.getType())) {
                this.sendLatticeComm.sendPlcLatticeCmd(String.valueOf(0), "0");
                needUploadFull = true;
            } else if (LatticeActionEnum.BATCH_LATTICE_LOCK.getKey().equals(queryData.getType())) {
                this.sendLatticeComm.sendPlcLatticeCmd(queryData.getLatticeNos(), "1");
            } else if (LatticeActionEnum.BATCH_LATTICE_UNLOCK.getKey().equals(queryData.getType())) {
                this.sendLatticeComm.sendPlcLatticeCmd(queryData.getLatticeNos(), "0");
            }
            commonData.setMty(MtyEnum.LATTICE_STATUS_RESP.getKey());
            resp.setData((Object)commonData);
            if (needUploadFull) {
                HASHED_WHEEL_TIMER.newTimeout(timeout -> this.latticeLockService.uploadAllLatticeStatus(), 3L, TimeUnit.SECONDS);
            }
        } else if (MtyEnum.CF_QUERY.getKey().equals(mty)) {
            WrongSortQueryReq sortQueryReq = (WrongSortQueryReq)json.toJavaObject(WrongSortQueryReq.class);
            CFAnalysisResult analysisResult = this.latticeLockService.calcWrongSort(sortQueryReq);
            analysisResult.setServerTime(servTime);
            analysisResult.setMty(MtyEnum.CF_QUERY_RESP.getKey());
            resp.setData((Object)analysisResult);
        } else if (MtyEnum.WRONG_SUPPLY_REQ.getKey().equals(mty)) {
            DeviceErrorRecordReq errorRecordReq = (DeviceErrorRecordReq)json.toJavaObject(DeviceErrorRecordReq.class);
            PageInfo recordPageInfo = this.deviceErrorRecordService.selectWrongSupplyList(errorRecordReq);
            DeviceErrorRecordListDataResp data = new DeviceErrorRecordListDataResp();
            data.setServerTime(servTime);
            data.setMty(MtyEnum.WRONG_SUPPLY_RESP.getKey());
            data.setPageNum(recordPageInfo.getPageNum());
            data.setPageSize(recordPageInfo.getPageSize());
            data.setTotal(recordPageInfo.getTotal());
            data.setList(recordPageInfo.getList());
            resp.setData((Object)data);
        } else if (MtyEnum.ABNORMAL_SUPPLY_RECORD_REQ.getKey().equals(mty)) {
            AbnormalSupplyRecordReq abnormalSupplyRecordReq = (AbnormalSupplyRecordReq)json.toJavaObject(AbnormalSupplyRecordReq.class);
            List records = this.abnormalSupplyService.getAbnormalSupplyRecord(abnormalSupplyRecordReq);
            SortRecordListDataResp data = new SortRecordListDataResp();
            int totalItems = records.size();
            if (totalItems == 0) {
                data.setPageNum(1);
                data.setPageSize(records.size());
                data.setTotal((long)records.size());
                data.setPages(1);
                data.setList(records);
            } else {
                Integer pageNum = 1;
                Integer pageSize = 10;
                int pageTotal = (int)Math.ceil((double)totalItems / (double)pageSize.intValue());
                if (Objects.nonNull(abnormalSupplyRecordReq.getPageNum()) && (pageNum = Integer.valueOf(Integer.parseInt(abnormalSupplyRecordReq.getPageNum()))) > pageTotal) {
                    pageNum = pageTotal;
                }
                if (Objects.nonNull(abnormalSupplyRecordReq.getPageSize())) {
                    pageSize = Integer.parseInt(abnormalSupplyRecordReq.getPageSize());
                }
                int startIndex = (pageNum - 1) * pageSize;
                int endIndex = Math.min(startIndex + pageSize, totalItems);
                List result = records.subList(startIndex, endIndex);
                data.setPageNum(pageNum.intValue());
                data.setPageSize(pageSize.intValue());
                data.setPages(pageTotal);
                data.setTotal((long)totalItems);
                data.setList(result);
            }
            data.setServerTime(servTime);
            data.setMty(MtyEnum.ABNORMAL_SUPPLY_RECORD_RESP.getKey());
            resp.setData((Object)data);
        } else if (MtyEnum.PLC_PARAM_REQ.getKey().equals(mty)) {
            ParamQueryAndSetReq queryAndSetReq = (ParamQueryAndSetReq)json.toJavaObject(ParamQueryAndSetReq.class);
            ParamQueryAndSetResp data = new ParamQueryAndSetResp();
            data.setServerTime(servTime);
            data.setMty(MtyEnum.PLC_PARAM_RESP.getKey());
            try {
                if (CollectionUtil.isEmpty((Map)PlcGateWay.devNoConnectMap)) {
                    logger.info("\u5f53\u524d\u7f13\u5b58\u65e0plc\u8fde\u63a5");
                    if ("1".equals(queryAndSetReq.getType())) {
                        this.plcParamService.buildParamSetResp(queryAndSetReq, data);
                    }
                } else {
                    this.plcParamService.handleParamReq(queryAndSetReq);
                    if ("1".equals(queryAndSetReq.getType())) {
                        HASHED_WHEEL_TIMER.newTimeout(timeout -> this.plcParamService.buildParamSetResp(queryAndSetReq, data), 1L, TimeUnit.SECONDS);
                        Thread.sleep(1500L);
                    }
                }
                resp.setData((Object)data);
            }
            catch (Exception e) {
                logger.error("plc\u67e5\u8be2\u8bbe\u7f6e\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            }
        }
        logger.info("\u8fd4\u56de\u5ba2\u6237\u7aef:{},\u8017\u65f6:[{}]ms", (Object)JSONObject.toJSONString((Object)resp), (Object)(System.currentTimeMillis() - start));
        return resp;
    }

    @PostMapping(value={"/test/ping"}, produces={"application/json"})
    @ApiOperation(value="ping", httpMethod="POST", produces="application/json")
    public ClientHttpResponse ping(HttpServletRequest request) {
        ClientHttpResponse resp = new ClientHttpResponse();
        resp.setData((Serializable)((Object)"pong"));
        resp.setRespcode("000");
        resp.setRespMessage("\u6210\u529f");
        return resp;
    }
}

