/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.controller;

import cn.yto.constants.ResponseTypeEnum;
import cn.yto.entity.ClientHttpResponse;
import cn.yto.entity.upgrade.AppUpdateEntity;
import cn.yto.entity.upgrade.AppUpgradeInfo;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.service.AppInfoService;
import cn.yto.utils.FileUtil;
import cn.yto.utils.UpgradeUtils;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/Yto_Server"})
public class SystemManagerController {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private final AtomicBoolean upgradeLock = new AtomicBoolean(false);
    @Autowired
    private AppInfoService appInfoService;
    @Value(value="${server.port}")
    private String serverPort;

    @PostMapping(value={"/getAppVersion"}, produces={"application/json"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u7248\u672c\u53f7", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse<String> getAppVersion(@RequestParam(value="needLog", required=false, defaultValue="true") boolean needLog) {
        ClientHttpResponse response = new ClientHttpResponse();
        if (needLog) {
            logger.info("\u6536\u5230\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u7248\u672c\u53f7\u8bf7\u6c42\u3002");
        }
        HashMap<String, Object> res = new HashMap<String, Object>(4);
        res.put("fastdfs", true);
        res.put("gatewayPath", "");
        File file = new File(FileUtil.getAppDir());
        if (file.exists() && file.isDirectory()) {
            res.put("gatewayPath", file.getName());
            Date fileCreationTime = FileUtil.getFileCreationTime((File)file);
            res.put("dirCreationTime", fileCreationTime);
        }
        try {
            res.put("version", this.appInfoService.getMonitorSysVersion());
        }
        catch (Exception e) {
            if (needLog) {
                logger.error("\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u7248\u672c\u53f7\u5f02\u5e38", (Throwable)e);
            }
            res.put("version", "");
        }
        response.setData((Serializable)((Object)JSONObject.toJSONString(res)));
        if (needLog) {
            logger.info("\u83b7\u53d6\u5f53\u524d\u5e94\u7528\u7248\u672c\u53f7\u54cd\u5e94:" + JSONObject.toJSONString((Object)response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/updateAppNew"}, produces={"application/json"})
    @ApiOperation(value="\u5e94\u7528\u66f4\u65b0\u65b0\u63a5\u53e3", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse<String> updateAppNew(@RequestParam(value="filePath") String jsonData) {
        logger.info("\u6536\u5230\u5e94\u7528\u66f4\u65b0\u8bf7\u6c42\uff1a" + jsonData);
        ClientHttpResponse response = new ClientHttpResponse();
        if (!this.upgradeLock.compareAndSet(false, true)) {
            logger.error("\u672c\u6b21\u4e3a\u91cd\u590d\u5347\u7ea7");
            response.setRespcode(ResponseTypeEnum.HIGH_FREQUENCY.getRespCode());
            response.setRespMessage("\u6b63\u5728\u5347\u7ea7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u5347\u7ea7");
            return response;
        }
        try {
            AppUpgradeInfo upgradeInfo = (AppUpgradeInfo)JSONObject.parseObject((String)jsonData, AppUpgradeInfo.class);
            File newAppFile = null;
            ClientHttpResponse clientHttpResponse = SystemManagerController.class;
            synchronized (SystemManagerController.class) {
                ClientHttpResponse clientHttpResponse2;
                newAppFile = UpgradeUtils.getNewAppFromLocal((String)upgradeInfo.getVersion());
                boolean isExist = newAppFile.exists() && newAppFile.isFile();
                logger.info(isExist ? "\u4e34\u65f6\u76ee\u5f55\u5b58\u5728\u65b0\u5305" : "\u4e34\u65f6\u76ee\u5f55\u4e0d\u5b58\u5728\u65b0\u5305");
                if (!isExist) {
                    HashMap result = new HashMap(5);
                    AppUpdateEntity param = new AppUpdateEntity();
                    param.setAppVersion(upgradeInfo.getVersion());
                    param.setAppName(upgradeInfo.getAppFileName());
                    UpgradeUtils.downloadAppNewWay(result, (AppUpdateEntity)param);
                    newAppFile = UpgradeUtils.saveAppFileToTemp((byte[])((byte[])result.get("appBinary")), (String)String.valueOf(result.get("appFileName")));
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                if (newAppFile == null) {
                    logger.error("\u672c\u5730\u4fdd\u5b58\u5b89\u88c5\u5305\u5931\u8d25\u3002");
                    response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                    response.setRespMessage("\u672c\u5730\u4fdd\u5b58\u5b89\u88c5\u5305\u5931\u8d25");
                    clientHttpResponse = response;
                    return clientHttpResponse;
                }
                String oldVersion = this.appInfoService.getMonitorSysVersion();
                String targetDir = UpgradeUtils.createUnzipDir((String)upgradeInfo.getVersion(), (String)oldVersion);
                File newFile = UpgradeUtils.unZipAppFile((File)newAppFile, (String)targetDir);
                if (newFile == null) {
                    logger.error("\u89e3\u538b\u5b89\u88c5\u5305\u5931\u8d25\u3002");
                    response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                    response.setRespMessage("\u5b89\u88c5\u5305\u89e3\u6790\u5931\u8d25");
                    clientHttpResponse2 = response;
                    return clientHttpResponse2;
                }
                if (!UpgradeUtils.modifySettingFiles((File)newFile)) {
                    logger.error("\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\u3002");
                    response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
                    response.setRespMessage("\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
                    clientHttpResponse2 = response;
                    return clientHttpResponse2;
                }
                response.setData((Serializable)((Object)newFile.getPath()));
                logger.info("\u54cd\u5e94\u5e94\u7528\u66f4\u65b0\u8bf7\u6c42\uff0c\u7ed3\u679c " + JSONObject.toJSONString((Object)response));
                clientHttpResponse2 = response;
                return clientHttpResponse2;
            }
        }
        finally {
            this.upgradeLock.set(false);
        }
    }

    @PostMapping(value={"restartApp"}, produces={"application/json"})
    @ApiOperation(value="\u91cd\u542f\u5e94\u7528", httpMethod="POST", consumes="application/json")
    public ClientHttpResponse restartApp(@RequestParam(value="newAppFolder", required=false) String newAppFolder) {
        File restartBatPath;
        logger.info("\u6536\u5230\u91cd\u542f\u5e94\u7528\u8bf7\u6c42:" + newAppFolder);
        ClientHttpResponse response = new ClientHttpResponse();
        if (StringUtils.isBlank((CharSequence)newAppFolder)) {
            newAppFolder = FileUtil.getAppDir();
        }
        if ((restartBatPath = new File(newAppFolder + File.separator + UpgradeUtils.getRestartScriptName())).exists() && restartBatPath.isFile()) {
            UpgradeUtils.restartApp((String)newAppFolder, (String)this.serverPort);
        } else {
            response.setRespcode(ResponseTypeEnum.APP_UPDATE_ERROR.getRespCode());
            response.setRespMessage("\u5e94\u7528\u8def\u5f84\u4e0d\u5b58\u5728\u3002");
            logger.error("\u5e94\u7528\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8def\u5f84\uff1a" + newAppFolder);
        }
        logger.info("\u54cd\u5e94\u91cd\u542f\u5e94\u7528\u8bf7\u6c42\uff0c\u7ed3\u679c" + JSONObject.toJSONString((Object)response));
        return response;
    }
}

