/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.controller;

import cn.yto.cache.DeviceRecordCacheService;
import cn.yto.cache.LatticeBindCacheService;
import cn.yto.cache.LatticeCacheService;
import cn.yto.communication.plc.send.SendMotorComm;
import cn.yto.communication.plc.send.SendParamSetComm;
import cn.yto.communication.plc.send.SendTopScanComm;
import cn.yto.communication.plc.send.SendUnlockLatticeComm;
import cn.yto.entity.BaseResponse;
import cn.yto.entity.DeviceSortRecord;
import cn.yto.entity.ExpLatticeBindEntity;
import cn.yto.entity.ParamEntity;
import cn.yto.entity.ParamQueryAndSetReq;
import cn.yto.entity.ParamQueryAndSetResp;
import cn.yto.entity.busigateway.response.AbnormalSupplyRecordReq;
import cn.yto.entity.busigateway.response.DeviceErrorRecordReq;
import cn.yto.netty.client.plc.PlcGateWayClient;
import cn.yto.service.AbnormalSupplyService;
import cn.yto.service.DeviceErrorRecordService;
import cn.yto.service.MsgProcHelperService;
import cn.yto.service.PlcParamService;
import cn.yto.service.devicesort.DeviceSortRecordService;
import cn.yto.utils.ExpUtils;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5de5\u5177\u63a5\u53e3")
@RestController
@RequestMapping(value={"/utils"})
public class UtilsController {
    @Autowired
    private LatticeCacheService latticeCacheService;
    @Autowired
    private DeviceSortRecordService deviceSortRecordService;
    @Autowired
    private PlcGateWayClient plcGateWayClient;
    @Autowired
    private DeviceRecordCacheService deviceRecordCacheService;
    @Autowired
    private AbnormalSupplyService abnormalSupplyService;
    @Autowired
    private PlcParamService plcParamService;
    @Autowired
    private SendParamSetComm sendParamSetComm;
    @Autowired
    private DeviceErrorRecordService deviceErrorRecordService;
    @Autowired
    private SendMotorComm sendMotorComm;
    @Autowired
    private LatticeBindCacheService latticeBindCacheService;

    @RequestMapping(value={"/heartMsg"}, method={RequestMethod.GET, RequestMethod.POST})
    @ApiOperation(value="plc<<---->>zxfj\u5fc3\u8df3\u62a5\u6587,\u6d88\u606f\u7c7b\u578b8600", httpMethod="POST", produces="application/json")
    @ApiImplicitParams(value={@ApiImplicitParam(name="seq", value="\u5e8f\u5217\u53f7,\u9ed8\u8ba40", paramType="query", dataType="Int"), @ApiImplicitParam(name="version", value="\u7248\u672c\u53f7,\u9ed8\u8ba40", paramType="query", dataType="Int"), @ApiImplicitParam(name="mty", value="\u6d88\u606f\u7c7b\u578b", required=true, paramType="query", dataType="Int"), @ApiImplicitParam(name="needBeauty", value="16\u8fdb\u5236\u62a5\u6587\u662f\u5426\u9700\u8981\u7a7a\u683c;1:\u9700\u8981,0:\u4e0d\u9700\u8981;\u9ed8\u8ba40", paramType="query", dataType="Int")})
    public BaseResponse getHeartBeatMessage(@RequestParam(defaultValue="0") Integer seq, @RequestParam(defaultValue="0") Integer version, @RequestParam Integer mty, @RequestParam(defaultValue="0") Integer needBeauty) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        resp.setMsg("\u6210\u529f");
        String data = MsgProcHelperService.genHeartBeatMessage((Integer)seq, (Integer)version, (Integer)mty, (Integer)10);
        if (needBeauty == 1) {
            data = MsgProcHelperService.beautyHexStr((String)data);
        }
        resp.setCode("000");
        resp.setData((Object)data);
        return resp;
    }

    @PostMapping(value={"/refreshLattice"}, produces={"application/json"})
    @ApiOperation(value="\u5237\u65b0\u683c\u53e3\u65b9\u6848", httpMethod="POST", produces="application/json")
    public BaseResponse refreshLattice() {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        this.latticeCacheService.refreshLatticeCache();
        return resp;
    }

    @RequestMapping(value={"/handleLeaveDeviceRecord"}, method={RequestMethod.GET, RequestMethod.POST})
    @ApiOperation(value="\u624b\u52a8\u8865\u4f20\u5206\u62e3\u8bb0\u5f55", httpMethod="POST", produces="application/json")
    public BaseResponse handLockLeaveTask() {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        resp.setMsg("\u6210\u529f");
        Long startTime = System.currentTimeMillis();
        this.deviceSortRecordService.procLeaveSortDatas();
        resp.setData((Object)("\u672c\u6b21\u8865\u4f20\u7ed3\u675f,\u6210\u529f\u6570\u91cf:" + DeviceSortRecordService.successCount + ",\u5931\u8d25\u6570\u91cf:" + DeviceSortRecordService.failCount + ",\u603b\u5171\u8017\u65f6:" + (System.currentTimeMillis() - startTime)));
        return resp;
    }

    @RequestMapping(value={"/pushLatticeCommand"}, method={RequestMethod.GET, RequestMethod.POST})
    @ApiOperation(value="wcs--->zxfj(\u683c\u53e3\u8bf7\u6c42\u6307\u4ee4\u7684\u62a5\u6587);\u6d88\u606f\u7c7b\u578b8660", httpMethod="POST", produces="application/json")
    @ApiImplicitParams(value={@ApiImplicitParam(name="seq", value="\u5e8f\u5217\u53f7,\u9ed8\u8ba40", paramType="query", dataType="Int"), @ApiImplicitParam(name="version", value="\u7248\u672c\u53f7,\u9ed8\u8ba40", paramType="query", dataType="Int"), @ApiImplicitParam(name="mty", value="\u6d88\u606f\u7c7b\u578b", required=true, paramType="query", dataType="Int"), @ApiImplicitParam(name="carNo", value="\u5c0f\u8f66\u53f7,\u9ed8\u8ba40", paramType="query", dataType="Int"), @ApiImplicitParam(name="layer", value="\u5c42\u6570,\u9ed8\u8ba40", paramType="query", dataType="Int"), @ApiImplicitParam(name="supplyNo", value="\u5c0f\u8f66\u53f7,\u9ed8\u8ba40", paramType="query", dataType="Int"), @ApiImplicitParam(name="waybillNo", value="\u5355\u53f7", paramType="query", dataType="String"), @ApiImplicitParam(name="needBeauty", value="16\u8fdb\u5236\u62a5\u6587\u662f\u5426\u9700\u8981\u7a7a\u683c;1:\u9700\u8981,0:\u4e0d\u9700\u8981;\u9ed8\u8ba40", paramType="query", dataType="Int")})
    public BaseResponse pushLatticeCommand(@RequestParam(defaultValue="0") Integer seq, @RequestParam(defaultValue="0") Integer version, @RequestParam Integer mty, @RequestParam(defaultValue="0") Integer carNo, @RequestParam(defaultValue="0") Integer layer, @RequestParam(defaultValue="0") Integer supplyNo, @RequestParam String waybillNo, @RequestParam(name="lattices") List<Integer> lattices, @RequestParam(defaultValue="0") Integer needBeauty) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        resp.setMsg("\u6210\u529f");
        String data = SendTopScanComm.topScanLatticeSortCommand((Integer)seq, (Integer)version, (Integer)mty, (Integer)carNo, (String)waybillNo, (Integer)layer, (Integer)supplyNo, lattices);
        if (needBeauty == 1) {
            data = MsgProcHelperService.beautyHexStr((String)data);
        }
        resp.setCode("000");
        resp.setData((Object)data);
        return resp;
    }

    @RequestMapping(value={"/unlockLatticeCommand"}, method={RequestMethod.GET, RequestMethod.POST})
    @ApiOperation(value="wcs-->zxfj(\u89e3\u9501\u6307\u4ee4);\u6d88\u606f\u7c7b\u578b8834", httpMethod="POST", produces="application/json")
    @ApiImplicitParams(value={@ApiImplicitParam(name="seq", value="\u5e8f\u5217\u53f7,\u9ed8\u8ba40", paramType="query", dataType="Int"), @ApiImplicitParam(name="version", value="\u7248\u672c\u53f7,\u9ed8\u8ba40", paramType="query", dataType="Int"), @ApiImplicitParam(name="mty", value="\u6d88\u606f\u7c7b\u578b", required=true, paramType="query", dataType="Int"), @ApiImplicitParam(name="unlockType", value="\u89e3\u9501\u7c7b\u578b,\u9ed8\u8ba41", paramType="query", dataType="Int"), @ApiImplicitParam(name="needBeauty", value="16\u8fdb\u5236\u62a5\u6587\u662f\u5426\u9700\u8981\u7a7a\u683c;1:\u9700\u8981,0:\u4e0d\u9700\u8981;\u9ed8\u8ba40", paramType="query", dataType="Int")})
    public BaseResponse sendUnlockLatticeCommand(@RequestParam(defaultValue="0") Integer seq, @RequestParam(defaultValue="0") Integer version, @RequestParam(defaultValue="1") Integer unlockType, @RequestParam Integer mty, @RequestParam(name="lattices") List<Integer> latticeNos, @RequestParam(defaultValue="0") Integer needBeauty) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        resp.setMsg("\u6210\u529f");
        String data = SendUnlockLatticeComm.latticeUnLockCommand((Integer)seq, (Integer)version, (Integer)mty, (Integer)unlockType, latticeNos);
        if (needBeauty == 1) {
            data = MsgProcHelperService.beautyHexStr((String)data);
        }
        resp.setCode("000");
        resp.setData((Object)data);
        return resp;
    }

    @GetMapping(value={"/getRecord"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse getRecord(@RequestParam(defaultValue="1") String devNo, @RequestParam(defaultValue="1") String tableNo, @RequestParam(required=false) String waybillNo) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        Stream<Object> stream = this.deviceRecordCacheService.initAndGetTableList(devNo, tableNo).stream();
        if (ExpUtils.isNotBlank((String)waybillNo)) {
            stream = stream.filter(e -> waybillNo.equals(e.getWaybillNo()));
        }
        List collect = stream.sorted(Comparator.comparing(DeviceSortRecord::getCameraTime).reversed()).collect(Collectors.toList());
        resp.setData(collect);
        return resp;
    }

    @GetMapping(value={"/config/query"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse getConfig(@RequestParam(defaultValue="1") String devNo, @RequestParam(required=false) String type) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        ParamQueryAndSetReq queryAndSetReq = new ParamQueryAndSetReq();
        if (ExpUtils.isNotBlank((String)type)) {
            ParamEntity entity = new ParamEntity();
            entity.setParamType(type);
            queryAndSetReq.setParamList(Collections.singletonList(entity));
        }
        ParamQueryAndSetResp data = new ParamQueryAndSetResp();
        this.plcParamService.buildParamSetResp(queryAndSetReq, data);
        resp.setData((Object)data);
        return resp;
    }

    @GetMapping(value={"/config/set"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse setConfig(@RequestParam(defaultValue="1") String devNo, String type, String value) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        this.sendParamSetComm.sendPlcParamSetCmd(devNo, type, value);
        return resp;
    }

    @GetMapping(value={"/motor"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse setConfig(@RequestParam(defaultValue="1") String devNo, String args) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        this.sendMotorComm.sendPlcMotorCmd(devNo, args);
        return resp;
    }

    @GetMapping(value={"/abnormalRecord"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse getAbnormalRecord(@RequestParam(defaultValue="1") String devNo, @RequestParam(required=false) String waybillNo, @RequestParam(defaultValue="1") String tableNo) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        AbnormalSupplyRecordReq abnormalSupplyRecordReq = new AbnormalSupplyRecordReq();
        abnormalSupplyRecordReq.setLayerNo(devNo);
        if (ExpUtils.isNotBlank((String)waybillNo)) {
            abnormalSupplyRecordReq.setWaybillNo(waybillNo);
        }
        if (ExpUtils.isNotBlank((String)tableNo)) {
            abnormalSupplyRecordReq.setWaybillNo(tableNo);
        }
        List records = this.abnormalSupplyService.getAbnormalSupplyRecord(abnormalSupplyRecordReq);
        resp.setData((Object)records);
        return resp;
    }

    @GetMapping(value={"/wrongSupply"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse getWrongSupply(@RequestParam(required=false) String waybillNo, @RequestParam(required=false) String deviceIp) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        DeviceErrorRecordReq deviceErrorRecordReq = new DeviceErrorRecordReq();
        if (ExpUtils.isNotBlank((String)waybillNo)) {
            deviceErrorRecordReq.setWaybillNo(waybillNo);
        }
        if (ExpUtils.isNotBlank((String)deviceIp)) {
            deviceErrorRecordReq.setDeviceIp(deviceIp);
        }
        PageInfo recordPageInfo = this.deviceErrorRecordService.selectWrongSupplyList(deviceErrorRecordReq);
        resp.setData((Object)recordPageInfo);
        return resp;
    }

    @GetMapping(value={"/clearSupplyCache"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse clearCache(@RequestParam String devNo, @RequestParam String tableNo) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        this.deviceRecordCacheService.deleteTableCache(tableNo, devNo);
        return resp;
    }

    @GetMapping(value={"/clearPkgWeightCache"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse clearPkghCache(@RequestParam String latticeNo) {
        BaseResponse resp = new BaseResponse();
        resp.setCode("000");
        ExpLatticeBindEntity latticeBindEntity = this.latticeBindCacheService.getLatticeBindCacheByLatticeNo(latticeNo);
        if (Objects.isNull(latticeBindEntity) || ExpUtils.isBlank((String)latticeBindEntity.getPackageNo())) {
            resp.setData((Object)"\u67e5\u4e0d\u5230\u683c\u53e3\u7684\u7ed1\u5b9a\u8bb0\u5f55");
            return resp;
        }
        String packageNo = latticeBindEntity.getPackageNo();
        if (DeviceRecordCacheService.packageWeightCache.containsKey(packageNo)) {
            DeviceRecordCacheService.packageWeightCache.remove(packageNo);
            resp.setData((Object)("\u6e05\u7406\u5305\u7b7e" + packageNo));
        } else {
            resp.setData((Object)("\u7f13\u5b58\u672a\u67e5\u5230\u5305\u7b7e" + packageNo));
        }
        return resp;
    }
}

