/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.base.page;

import java.io.Serializable;
import java.util.ArrayList;

public class Sort
implements Serializable {
    private static final long serialVersionUID = -1392714341585793291L;
    public static final String ASC = "asc";
    public static final String DESC = "desc";
    private String field;
    private String type = "asc";

    public Sort() {
        this.field = "";
        this.type = ASC;
    }

    public Sort(String sortStr) {
        String[] strs = sortStr.trim().split(" ");
        this.field = strs[0];
        if (strs.length > 1) {
            if (ASC.equalsIgnoreCase(strs[1])) {
                this.type = ASC;
            } else if (DESC.equalsIgnoreCase(strs[1])) {
                this.type = DESC;
            } else {
                throw new RuntimeException("Wrong sort type definition, only asc or desc are supported.");
            }
        }
    }

    public Sort(String field, String type) {
        this.field = field;
        this.type = type;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sort other = (Sort)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return this.field + " " + this.type;
    }

    public static Sort[] parse(String sortStr) {
        if (sortStr == null || sortStr.trim().length() == 0) {
            return null;
        }
        String[] sorts = sortStr.split(",");
        ArrayList<Sort> list = new ArrayList<Sort>();
        for (String s : sorts) {
            String order;
            String[] strs = s.trim().split(":");
            String string = order = strs.length > 1 ? strs[1] : ASC;
            if (!ASC.equalsIgnoreCase(order) && !DESC.equalsIgnoreCase(order)) {
                throw new RuntimeException();
            }
            list.add(new Sort(strs[0], order));
        }
        return list.toArray(new Sort[0]);
    }

    public static String toSortStr(Sort[] sorts) {
        StringBuffer sbSortStr = new StringBuffer();
        for (int i = 0; i < sorts.length; ++i) {
            sbSortStr.append(sorts[i].toString());
            if (i == sorts.length - 1) continue;
            sbSortStr.append(",");
        }
        return sbSortStr.toString();
    }
}

