/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.web.common.base;

import cn.yto.base.exception.BusinessException;
import cn.yto.base.exception.DataIntegrityViolationException;
import cn.yto.base.exception.DuplicateKeyException;
import cn.yto.base.exception.MissingParameterException;
import cn.yto.base.exception.TypeMismatchException;
import cn.yto.base.exception.UnknownException;
import cn.yto.base.page.Pagination;
import cn.yto.web.common.convert.DateConvertEditor;
import cn.yto.web.common.i18n.Resources;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import java.beans.PropertyEditor;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;

public abstract class BaseController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected Map<String, Object> returnSuccess() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", true);
        return map;
    }

    protected Map<String, Object> returnSuccess(String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", true);
        map.put("message", msg);
        return map;
    }

    protected Map<String, Object> returnSuccess(Object data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", true);
        if (data != null) {
            Pagination page;
            if (data instanceof Pagination) {
                page = (Pagination)data;
                map.put("rows", page.getData());
                if (null != page.getPage()) {
                    map.put("total", page.getPage().getTotal());
                }
            }
            if (data instanceof Page) {
                page = (Page)data;
                map.put("rows", page.getResult());
                map.put("total", page.getTotal());
            } else if (data instanceof List) {
                map.put("data", data);
            } else {
                map.put("data", data);
            }
        }
        return map;
    }

    protected Map<String, Object> returnSuccess(Object data, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", true);
        if (data != null) {
            if (data instanceof Pagination) {
                Pagination page = (Pagination)data;
                map.put("rows", page.getData());
                map.put("total", page.getPage().getTotal());
            } else if (data instanceof List) {
                map.put("data", data);
            } else {
                map.put("data", data);
            }
        }
        map.put("message", message);
        return map;
    }

    protected Map<String, Object> returnError(String meg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", false);
        map.put("message", meg);
        return map;
    }

    protected Map<String, Object> returnError(String code, String meg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", false);
        map.put("code", code);
        map.put("message", meg);
        return map;
    }

    protected Map<String, Object> returnError(BusinessException e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", false);
        map.put("message", e.getMessage());
        return map;
    }

    protected void printStackTraceAsCause(Exception ex, StringBuffer buffer) {
        String cause;
        if (ex == null) {
            return;
        }
        String string = cause = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
        if (StringUtils.isNotBlank((CharSequence)cause)) {
            if (cause.length() > 500) {
                buffer.append(cause.substring(0, 500));
            } else {
                buffer.append(cause);
            }
        }
    }

    @InitBinder
    private void dateBinder(WebDataBinder binder) {
        binder.setAutoGrowCollectionLimit(10000);
        binder.registerCustomEditor(Date.class, (PropertyEditor)new DateConvertEditor());
    }

    @ExceptionHandler(value={Exception.class})
    public void exceptionHandler(HttpServletRequest request, HttpServletResponse response, Exception ex) throws Exception {
        String errorCode;
        StringBuffer stackTrace;
        String message;
        Map<Object, Object> map;
        block11: {
            this.logger.error("\u6846\u67b6\u6355\u83b7\u5230\u5f02\u5e38", (Throwable)ex);
            map = new HashMap();
            message = null;
            stackTrace = null;
            errorCode = null;
            try {
                if (ex instanceof UnauthorizedException) {
                    message = Resources.getMessage("error.system.unauthorized", new Object[0]);
                    break block11;
                }
                if (ex instanceof BusinessException) {
                    errorCode = ((BusinessException)ex).getCode();
                    message = ((BusinessException)ex).getMessage();
                    message = message == null ? Resources.getMessage(errorCode, new Object[0]) : Resources.getMessage(message, new Object[0]);
                    break block11;
                }
                if (ex instanceof IllegalArgumentException) {
                    message = ((IllegalArgumentException)ex).getMessage();
                    break block11;
                }
                if (ex instanceof DataIntegrityViolationException) {
                    message = Resources.getMessage("error.system.dataintegrityviolation", new Object[0]);
                    break block11;
                }
                if (ex instanceof DuplicateKeyException) {
                    message = Resources.getMessage("error.system.duplicatekey", new Object[0]);
                    break block11;
                }
                if (ex instanceof MissingParameterException) {
                    message = Resources.getMessage("error.system.missingparameter", new Object[0]);
                    break block11;
                }
                if (ex instanceof TypeMismatchException) {
                    message = Resources.getMessage("error.system.typemismatch", new Object[0]);
                    break block11;
                }
                if (ex instanceof UnknownException) {
                    message = Resources.getMessage("error.system.unknown", new Object[0]);
                    break block11;
                }
                stackTrace = new StringBuffer(2000);
                this.printStackTraceAsCause(ex, stackTrace);
                message = Resources.getMessage("error.system.unknown", new Object[0]);
                throw ex;
            }
            catch (Exception e) {
                e.getStackTrace();
                if (errorCode == null) break block11;
                message = ex.getMessage() != null ? ex.getMessage() : errorCode;
            }
        }
        Map<String, Object> map2 = map = errorCode == null ? this.returnError(message) : this.returnError(errorCode, message);
        if (stackTrace != null) {
            map.put("stackTrace", stackTrace.toString());
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json;charset=utf-8");
        String str = JSONObject.toJSONString(map);
        response.getWriter().write(JSONObject.toJSONString(map));
    }

    public void setResponseHeader(HttpServletResponse response, String fileName) {
        try {
            try {
                fileName = new String(fileName.getBytes(), "ISO8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        NullPointerException nullPointerException = new NullPointerException();
        System.out.println(nullPointerException.getCause());
        System.out.println(nullPointerException.getMessage());
        System.out.println(JSON.toJSONString((Object)nullPointerException.getStackTrace()));
    }
}

