/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.web.common.filter;

import cn.yto.web.common.util.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class ModuleManager {
    private static final Log LOGGER = LogFactory.getLog(ModuleManager.class);
    private static PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private static final String PACKAGE_PREFIX = "cn/yto/";
    private static final String PAGES_FROM = "/web/META-INF/pages/";
    private static final String PAGES_TO = "/WEB-INF/pages/";
    private static final String PAGES_SUFFIX = "";
    private static final String SCRIPTS_FROM = "/web/META-INF/scripts/";
    private static final String SCRIPTS_TO = "/scripts/";
    private static final String SCRIPTS_SUFFIX = "";
    private static final String STYLES_FROM = "/web/META-INF/styles/";
    private static final String STYLES_TO = "/styles/";
    private static final String STYLES_SUFFIX = "";
    private static final String IMAGES_FROM = "/web/META-INF/images/";
    public static final String IMAGES_TO = "/images/";
    private static final String IMAGES_SUFFIX = "";

    private ModuleManager() {
    }

    public static void export(ServletContext servletContext) {
        ModuleManager.export(servletContext, PAGES_FROM, PAGES_TO, "");
        ModuleManager.export(servletContext, SCRIPTS_FROM, SCRIPTS_TO, "");
        ModuleManager.export(servletContext, STYLES_FROM, STYLES_TO, "");
        ModuleManager.export(servletContext, IMAGES_FROM, IMAGES_TO, "");
    }

    private static void export(ServletContext servletContext, String from, String to, String suffix) {
        try {
            Resource[] resources;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("[Framework] servlet root dir: " + servletContext.getRealPath("/")));
            }
            if ((resources = resolver.getResources("classpath*:cn/yto/**" + from + "**" + suffix)) != null && resources.length > 0) {
                for (Resource resource : resources) {
                    try {
                        boolean b;
                        File dir;
                        String path = resource.getURL().getPath();
                        int j = path.lastIndexOf(from);
                        String pathHeader = path.substring(0, j);
                        int i = pathHeader.lastIndexOf(47);
                        String module = path.substring(i + 1, j);
                        String page = path.substring(j + from.length());
                        String dist = to + module + "/" + page;
                        File file = new File(servletContext.getRealPath(dist));
                        if (!file.getName().matches("^.*[.].*$") && !(dir = new File(file.getPath() + "\\" + File.separator)).exists()) {
                            b = file.mkdirs();
                            if (!b) {
                                LOGGER.warn((Object)"create dir failure!");
                            }
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info((Object)("[Framework] create dir: " + dir));
                            }
                        }
                        if (!(dir = file.getParentFile()).exists()) {
                            b = dir.mkdirs();
                            if (!b) {
                                LOGGER.warn((Object)"create dir failure!");
                            }
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info((Object)("[Framework] create dir: " + dir));
                            }
                        }
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)("[Framework] release resource: " + dist));
                        }
                        FileOutputStream out = new FileOutputStream(file);
                        InputStream in = resource.getInputStream();
                        IOUtils.copy(in, out, true);
                        file.setLastModified(resource.lastModified());
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

