/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.web.common.interceptor;

import cn.yto.base.page.BasePage;
import cn.yto.base.page.Sort;
import cn.yto.web.common.model.EasyUIPage;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class EasyUIPageInterceptor
extends HandlerInterceptorAdapter {
    public static final String CUR_PAGE = "page";
    public static final String PAGE_SIZE = "rows";
    public static final String ORDER_COL = "sort";
    public static final String ORDER = "order";
    public static final String TOTAL_ROWS = "total";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        if (handler instanceof HandlerMethod && Map.class.isAssignableFrom((handlerMethod = (HandlerMethod)handler).getReturnType().getParameterType())) {
            MethodParameter[] parameters;
            for (MethodParameter parameter : parameters = handlerMethod.getMethodParameters()) {
                if (!parameter.getParameterType().isAssignableFrom(BasePage.class)) continue;
                this.before(request);
                break;
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        HandlerMethod handlerMethod;
        if (handler instanceof HandlerMethod && Collection.class.isAssignableFrom((handlerMethod = (HandlerMethod)handler).getReturnType().getParameterType())) {
            MethodParameter[] parameters;
            for (MethodParameter parameter : parameters = handlerMethod.getMethodParameters()) {
                if (!parameter.getParameterType().isAssignableFrom(EasyUIPage.class)) continue;
                this.after(request, modelAndView);
                break;
            }
        }
    }

    private void before(HttpServletRequest request) {
        Integer currentPage = this.getInteger(request, CUR_PAGE);
        if (currentPage != null) {
            Map map = request.getParameterMap();
            this.setLocked(map, false);
            BasePage page = new BasePage();
            page.setQueryCount(Boolean.valueOf(true));
            page.setCurrentPage(currentPage.intValue());
            map.remove(CUR_PAGE);
            page.setPageSize(this.getInteger(request, PAGE_SIZE).intValue());
            map.remove(PAGE_SIZE);
            String order = this.getParameter(request, ORDER);
            if (order != null) {
                String sortColumn = this.getParameter(request, ORDER_COL);
                Sort sort = new Sort();
                sort.setField(sortColumn);
                map.remove(ORDER_COL);
                if (order.equalsIgnoreCase("desc")) {
                    sort.setType("desc");
                } else {
                    sort.setType("asc");
                }
                page.setSort(sort);
                map.remove(ORDER);
            }
            this.setLocked(map, true);
            request.setAttribute(CUR_PAGE, (Object)page);
        }
    }

    private void after(HttpServletRequest request, ModelAndView modelAndView) {
        request.removeAttribute(CUR_PAGE);
    }

    private Integer getInteger(HttpServletRequest request, String paramName) {
        try {
            return Integer.valueOf(this.getParameter(request, paramName));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getParameter(HttpServletRequest request, String paramName) {
        String value = request.getParameter(paramName);
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    private void setLocked(Map<String, ?> map, boolean locked) {
        try {
            BeanUtils.getPropertyDescriptor(map.getClass(), (String)"locked").getWriteMethod().invoke(map, locked);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

