/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.web.common.listener;

import com.alibaba.fastjson.parser.ParserConfig;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@WebListener
@Component
public class InitListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(InitListener.class);
    private String fastjsonParserConfig = "cn.yto.";
    @Value(value="${yto.staticServerAddress:http://static.yto56.com.cn}")
    private String staticResourceAddress;
    @Value(value="${yto-project-source-version:1}")
    private String sourceVersion;
    @Value(value="${yto-out-static-source:}")
    private String outStaticSource;
    private static final Log logger = LogFactory.getLog(InitListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        ParserConfig.getGlobalInstance().addAccept(this.fastjsonParserConfig);
        try {
            sce.getServletContext().setAttribute("SYSTEM_NAME", (Object)sce.getServletContext().getInitParameter("sysName"));
            sce.getServletContext().setAttribute("STATIC_SERVERADDRESS", (Object)this.staticResourceAddress);
            sce.getServletContext().setAttribute("SOURCE_VERSION", (Object)this.sourceVersion);
            if (StringUtils.isNotEmpty((CharSequence)this.outStaticSource)) {
                sce.getServletContext().setAttribute("OUT_STATIC_SOURCE", (Object)(this.outStaticSource + ".css?v=" + this.sourceVersion));
            } else {
                sce.getServletContext().setAttribute("OUT_STATIC_SOURCE", (Object)"");
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)"InitListener success !");
            }
        }
        catch (Exception e) {
            logger.error((Object)"InitListener fail ", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

