/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.web.common.util;

import cn.yto.utils.StringUtil;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodeGeneratorUtil {
    private static final Logger log = LoggerFactory.getLogger(CodeGeneratorUtil.class);

    private static void createFile(String url, String user, String pwd, String driver, String tableName, final String projectPath, String parent, final String module, String entityRule, String author, String baseEntity, String baseAction, final String actionFilePath, Boolean blRestful) {
        AutoGenerator mpg = new AutoGenerator();
        final String parentPath = parent.replace(".", "/");
        final String entity = CodeGeneratorUtil.underline2Camel(tableName, entityRule, false);
        if (StringUtil.isEmpty((String)entity)) {
            log.error("\u5b9e\u4f53\u540d\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!");
            return;
        }
        GlobalConfig gc = new GlobalConfig();
        gc.setOutputDir(projectPath + "/src/main/java");
        gc.setAuthor(author);
        gc.setEntityName(entity + "Entity");
        gc.setControllerName(entity + "Controller");
        gc.setServiceName(entity + "Service");
        gc.setServiceImplName(entity + "ServiceImpl");
        gc.setMapperName("I" + entity + "Dao");
        gc.setXmlName(entity + "Mapper");
        gc.setBaseResultMap(true);
        gc.setBaseColumnList(true);
        gc.setDateType(DateType.ONLY_DATE);
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl(url);
        dsc.setDriverName(driver);
        dsc.setUsername(user);
        dsc.setPassword(pwd);
        final PackageConfig pc = new PackageConfig();
        pc.setModuleName(module);
        pc.setParent(parent);
        pc.setMapper("dao");
        pc.setController("control");
        TemplateConfig templateConfig = new TemplateConfig();
        templateConfig.setEntity("/ftl/Entity.java");
        templateConfig.setController(null);
        templateConfig.setService("/ftl/Service.java");
        templateConfig.setServiceImpl(null);
        templateConfig.setMapper("/ftl/Dao.java");
        templateConfig.setXml(null);
        final InjectionConfig cfg = new InjectionConfig(){

            public void initMap() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("bizName", "I" + entity + "Biz");
                map.put("bizPackage", pc.getParent() + ".biz");
                map.put("bizImplName", entity + "Biz");
                map.put("jspName", entity);
                map.put("modelName", module);
                map.put("prex", "$");
                this.setMap(map);
            }
        };
        ArrayList<FileOutConfig> focList = new ArrayList<FileOutConfig>();
        focList.add(new FileOutConfig("/ftl/Mapper.xml.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return projectPath + "/src/main/resources/mapper/" + tableInfo.getXmlName() + ".xml";
            }
        });
        focList.add(new FileOutConfig("/ftl/Controller.java.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return actionFilePath + "/src/main/java/" + parentPath + "/" + module + "/control/" + tableInfo.getControllerName() + ".java";
            }
        });
        focList.add(new FileOutConfig("/ftl/IBiz.java.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return projectPath + "/src/main/java/" + parentPath + "/" + module + "/biz/" + cfg.getMap().get("bizName") + ".java";
            }
        });
        focList.add(new FileOutConfig("/ftl/Biz.java.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return projectPath + "/src/main/java/" + parentPath + "/" + module + "/biz/impl/" + cfg.getMap().get("bizImplName") + ".java";
            }
        });
        focList.add(new FileOutConfig("/ftl/Jsp.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return actionFilePath + "/src/main/resources/" + parentPath + "/" + module + "/web/META-INF/pages/" + entity + ".jsp";
            }
        });
        focList.add(new FileOutConfig("/ftl/js.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return actionFilePath + "/src/main/resources/" + parentPath + "/" + module + "/web/META-INF/scripts/" + entity + ".js";
            }
        });
        cfg.setFileOutConfigList(focList);
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setSuperEntityClass(baseEntity);
        strategy.setEntityLombokModel(true);
        strategy.setRestControllerStyle(blRestful.booleanValue());
        strategy.setSuperControllerClass(baseAction);
        strategy.setInclude(new String[]{tableName});
        strategy.setSuperEntityColumns(new String[]{"id"});
        strategy.setControllerMappingHyphenStyle(true);
        strategy.setTablePrefix(new String[]{pc.getModuleName() + "_"});
        mpg.setGlobalConfig(gc);
        mpg.setDataSource(dsc);
        mpg.setPackageInfo(pc);
        mpg.setCfg(cfg);
        mpg.setTemplate(templateConfig);
        mpg.setStrategy(strategy);
        mpg.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        mpg.execute();
    }

    public static void genearateCodeMain(String propertyFileName) {
        String tableNameSplit = ",";
        Properties properties = CodeGeneratorUtil.loadProperties(propertyFileName);
        String author = properties.getProperty("author");
        String dirPath = properties.getProperty("dir.path");
        if (dirPath == null || dirPath.length() == 0) {
            dirPath = System.getProperty("user.dir");
        }
        String dbUrl = properties.getProperty("db.url");
        String user = properties.getProperty("db.username");
        String pwd = properties.getProperty("db.password");
        String driverName = properties.getProperty("db.driver");
        String tableName = properties.getProperty("table.name");
        String parentName = properties.getProperty("package.name");
        String model = properties.getProperty("model.name");
        String entityRule = properties.getProperty("entity.name.rule");
        String baseEntity = properties.getProperty("base.entity.path");
        String baseAction = properties.getProperty("action.action.path");
        String actionFilePath = properties.getProperty("action.file.path");
        String restful = properties.getProperty("controller.blRestful");
        boolean blRestful = StringUtil.isNotEmpty((String)restful) ? (restful.equals("0") ? false : (restful.equals("1") ? true : true)) : false;
        if (StringUtil.isNotEmpty((String)tableName) && StringUtil.contains((String)tableName, (String)tableNameSplit)) {
            String[] tableNames;
            for (String tableNameTmp : tableNames = tableName.split(tableNameSplit)) {
                if (!StringUtil.isNotEmpty((String)tableNameTmp)) continue;
                CodeGeneratorUtil.createFile(dbUrl, user, pwd, driverName, tableNameTmp, dirPath, parentName, model, entityRule, author, baseEntity, baseAction, actionFilePath, blRestful);
            }
        } else {
            CodeGeneratorUtil.createFile(dbUrl, user, pwd, driverName, tableName, dirPath, parentName, model, entityRule, author, baseEntity, baseAction, actionFilePath, blRestful);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String propertyFileName) {
        InputStreamReader in = null;
        try {
            ClassLoader loder = Thread.currentThread().getContextClassLoader();
            in = new InputStreamReader(loder.getResourceAsStream(propertyFileName), "UTF-8");
            if (in != null) {
                Properties prop = new Properties();
                prop.load(in);
                Properties properties = prop;
                return properties;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static String underline2Camel(String sourceStr, String ignorePrefixStr, boolean smallCamel) {
        if (StringUtil.isNotEmpty((String)sourceStr)) {
            sourceStr = sourceStr.replaceAll(ignorePrefixStr, "");
        }
        if (StringUtil.isEmpty((String)sourceStr)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("([A-Za-z\\d]+)(_)?");
        Matcher matcher = pattern.matcher(sourceStr);
        while (matcher.find()) {
            String word = matcher.group();
            if (smallCamel) {
                sb.append(Character.toLowerCase(word.charAt(0)));
            } else {
                sb.append(Character.toUpperCase(word.charAt(0)));
            }
            int index = word.lastIndexOf(95);
            if (index > 0) {
                sb.append(word.substring(1, index).toLowerCase());
                continue;
            }
            sb.append(word.substring(1).toLowerCase());
        }
        return sb.toString();
    }
}

