/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.web.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class CookieUtil {
    public static void addCookie(HttpServletResponse response, String name, String value) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        Cookie cookie = new Cookie(name, value);
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int age) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(age);
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int age, String path) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(age);
        cookie.setPath(path);
        response.addCookie(cookie);
    }

    public static void refreshCookie(HttpServletRequest request, HttpServletResponse response, String name, int timeout) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        Cookie[] list = request.getCookies();
        if (list != null && list.length > 0) {
            for (Cookie cookie : list) {
                if (!name.equals(cookie.getName())) continue;
                cookie.setMaxAge(timeout);
                response.addCookie(cookie);
            }
        }
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, Consumer<Cookie> consumer) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        Cookie cook = null;
        Cookie[] list = request.getCookies();
        if (list != null && list.length > 0) {
            for (Cookie cookie : list) {
                if (!name.equals(cookie.getName())) continue;
                cook = cookie;
            }
        }
        if (cook == null) {
            cook = new Cookie(name, value);
        }
        consumer.accept(cook);
        response.addCookie(cook);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, Consumer<Cookie> consumer) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        Cookie cookie = new Cookie(name, value);
        consumer.accept(cookie);
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, String path) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        response.addCookie(cookie);
    }

    public static String getCookieValueByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookiesMap;
        Cookie[] cookies = request.getCookies();
        if (cookies != null && (cookiesMap = CookieUtil.getCookieMap(request)) != null && cookiesMap.containsKey(name)) {
            return cookiesMap.get(name).getValue();
        }
        return null;
    }

    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookiesMap = CookieUtil.getCookieMap(request);
        if (cookiesMap != null && cookiesMap.containsKey(name)) {
            return cookiesMap.get(name);
        }
        return null;
    }

    private static Map<String, Cookie> getCookieMap(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            HashMap<String, Cookie> cookiesMap = new HashMap<String, Cookie>();
            for (Cookie cookie : cookies) {
                cookiesMap.put(cookie.getName(), cookie);
            }
            return cookiesMap;
        }
        return null;
    }
}

