/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.web.common.util;

import cn.yto.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.net.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZIPHelper {
    private static Logger logger = LoggerFactory.getLogger(GZIPHelper.class);

    public static void main(String[] args) {
        String ticketData = "{\"<di v>=+</div>xx\":\"20170121 09:44:01\",\"fs\":[{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"003\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"005\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"004\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"007\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"008\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"026\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"033\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"034\",\"oids\":[\"0\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"035\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"037\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"038\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"041\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"042\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"047\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"046\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"048\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"051\",\"oids\":[\"1\"]},{\"usg\":[1,1,1,1,1,1,1],\"act\":0,\"fid\":\"053\",\"oids\":[\"4\"]}],\"qty\":1,\"sd\":\"20161021 09:44:01\",\"cd\":\"72016102116762039687\"}";
        try {
            String data = GZIPHelper.zip(ticketData);
            System.out.println("\u538b\u7f29\uff1a" + data);
            data = GZIPHelper.unZip(data);
            System.out.println("\u89e3\u538b\uff1a " + new String(data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String zip(String value) throws IOException {
        if (StringUtil.isNotEmpty((String)value)) {
            Long startTime = System.currentTimeMillis();
            String urlString = URLEncoder.encode(value, "UTF-8");
            byte[] dataBytes = GZIPHelper.zip(urlString.getBytes());
            Long endTime = System.currentTimeMillis();
            value = Base64.encodeBase64String((byte[])dataBytes);
            logger.info("\u538b\u7f29\u65f6\u95f4: " + (endTime - startTime) + "ms");
        }
        return value;
    }

    public static String unZip(String value) throws IOException {
        if (StringUtil.isNotEmpty((String)value)) {
            byte[] dataBytes = Base64.decodeBase64((String)value);
            String unzipValue = new String(GZIPHelper.unzip(dataBytes));
            unzipValue = URLDecoder.decode(unzipValue, "UTF-8");
            return unzipValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(byte[] value) throws IOException {
        ByteArrayOutputStream output = null;
        DeflaterOutputStream zip = null;
        try {
            byte[] arrayOfByte;
            output = new ByteArrayOutputStream();
            zip = new GZIPOutputStream(output);
            ((GZIPOutputStream)zip).write(value, 0, value.length);
            zip.close();
            byte[] byArray = arrayOfByte = output.toByteArray();
            return byArray;
        }
        finally {
            if (zip != null) {
                zip.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unzip(byte[] value) throws IOException {
        ByteArrayOutputStream output = null;
        ByteArrayInputStream input = null;
        GZIPInputStream zip = null;
        try {
            byte[] arrayOfByte1;
            int read;
            output = new ByteArrayOutputStream();
            input = new ByteArrayInputStream(value);
            zip = new GZIPInputStream(input);
            byte[] buffer = new byte[1024];
            while ((read = zip.read(buffer)) > 0) {
                output.write(buffer, 0, read);
            }
            byte[] byArray = arrayOfByte1 = output.toByteArray();
            return byArray;
        }
        finally {
            if (zip != null) {
                zip.close();
            }
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }
}

