/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.web.common.util;

import cn.yto.web.common.util.InstanceException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

public final class InstanceUtil {
    private InstanceUtil() {
    }

    public static final <T> T to(Object orig, Class<T> clazz) {
        T bean = null;
        try {
            bean = clazz.newInstance();
            PropertyUtils.copyProperties(bean, (Object)orig);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bean;
    }

    public static void transMap2Bean(Map<String, Object> map, Object obj) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (!map.containsKey(key)) continue;
                Object value = map.get(key);
                Method setter = property.getWriteMethod();
                setter.invoke(obj, value);
            }
        }
        catch (Exception e) {
            System.out.println("transMap2Bean Error " + e);
        }
    }

    public static Map<String, Object> transBean2Map(Object obj) {
        HashMap<String, Object> map = InstanceUtil.newHashMap();
        if (obj == null) {
            return map;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            System.out.println("transBean2Map Error " + e);
        }
        return map;
    }

    public static <T> T getDiff(T oldBean, T newBean) throws Exception {
        PropertyDescriptor[] propertyDescriptors;
        if (oldBean == null && newBean != null) {
            return newBean;
        }
        if (newBean == null) {
            return null;
        }
        Class<?> cls1 = oldBean.getClass();
        Object object = cls1.newInstance();
        BeanInfo beanInfo = Introspector.getBeanInfo(cls1);
        for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            String key = property.getName();
            if (key.equals("class")) continue;
            Method getter = property.getReadMethod();
            Method setter = property.getWriteMethod();
            Object oldValue = getter.invoke(oldBean, new Object[0]);
            Object newValue = getter.invoke(newBean, new Object[0]);
            if (newValue == null) continue;
            if (oldValue == null) {
                setter.invoke(object, newValue);
                continue;
            }
            if (newValue.equals(oldValue)) continue;
            setter.invoke(object, newValue);
        }
        return (T)object;
    }

    public static final Class<?> getClass(String clazz) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            if (loader != null) {
                return Class.forName(clazz, true, loader);
            }
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new InstanceException(e);
        }
    }

    public static final <E> List<E> getInstanceList(Class<E> cls, List<?> list) {
        ArrayList<Object> resultList = InstanceUtil.newArrayList();
        Object object = null;
        for (Map map : list) {
            object = InstanceUtil.newInstance(cls, new Object[]{map});
            resultList.add(object);
        }
        return resultList;
    }

    public static final <E> List<E> getInstanceList(Class<E> cls, ResultSet rs) {
        ArrayList<E> resultList = InstanceUtil.newArrayList();
        try {
            E object = cls.newInstance();
            Field[] fields = cls.getDeclaredFields();
            while (rs.next()) {
                object = cls.newInstance();
                for (int i = 0; i < fields.length; ++i) {
                    String fieldName = fields[i].getName();
                    PropertyUtils.setProperty(object, (String)fieldName, (Object)rs.getObject(fieldName));
                }
                resultList.add(object);
            }
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
        return resultList;
    }

    public static final <E> E newInstance(Class<E> cls, Map<String, ?> map) {
        E object = null;
        try {
            object = cls.newInstance();
            BeanUtils.populate(object, map);
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
        return object;
    }

    public static final Object newInstance(String clazz) {
        try {
            return InstanceUtil.getClass(clazz).newInstance();
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
    }

    public static final <K> K newInstance(Class<K> cls, Object ... args) {
        try {
            Class[] argsClass = null;
            if (args != null) {
                argsClass = new Class[args.length];
                int j = args.length;
                for (int i = 0; i < j; ++i) {
                    argsClass[i] = args[i].getClass();
                }
            }
            Constructor<K> cons = cls.getConstructor(argsClass);
            return cons.newInstance(args);
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
    }

    public static final Object newInstance(String className, Object ... args) {
        try {
            Class<?> newoneClass = Class.forName(className);
            return InstanceUtil.newInstance(newoneClass, args);
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
    }

    public static final Object invokeMethod(Object owner, String methodName, Object[] args) {
        Class<?> ownerClass = owner.getClass();
        Class[] argsClass = new Class[args.length];
        int j = args.length;
        for (int i = 0; i < j; ++i) {
            argsClass[i] = args[i].getClass();
        }
        try {
            Method method = ownerClass.getMethod(methodName, argsClass);
            return method.invoke(owner, args);
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
    }

    public static final <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static final <E> ArrayList<E> newArrayList(E ... e) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, e);
        return list;
    }

    public static final <k, v> HashMap<k, v> newHashMap() {
        return new HashMap();
    }

    public static final <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static final <k, v> Hashtable<k, v> newHashtable() {
        return new Hashtable();
    }

    public static final <k, v> LinkedHashMap<k, v> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static final <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static final <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static final <k, v> TreeMap<k, v> newTreeMap() {
        return new TreeMap();
    }

    public static final <E> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static final <E> Vector<E> newVector() {
        return new Vector();
    }

    public static final <k, v> WeakHashMap<k, v> newWeakHashMap() {
        return new WeakHashMap();
    }

    public static final <k, v> Map<k, v> newHashMap(k key, v value) {
        HashMap<k, v> map = InstanceUtil.newHashMap();
        map.put(key, value);
        return map;
    }

    public static final <k, v> ConcurrentHashMap<k, v> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }
}

