/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.web.common.util;

import cn.yto.web.common.base.CurrentUser;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.web.util.WebUtils;

public final class WebUtil {
    private WebUtil() {
    }

    public static final void saveCurrentUser(Object user) {
        WebUtil.setSession("CURRENT_USER", user);
    }

    public static final void removeCurrentUser(HttpServletRequest request) {
        request.getSession().removeAttribute("CURRENT_USER");
    }

    public static final CurrentUser getCurrentUser() {
        Session session;
        Subject currentUser = SecurityUtils.getSubject();
        if (null != currentUser && null != (session = currentUser.getSession())) {
            return (CurrentUser)session.getAttribute((Object)"CURRENT_USER");
        }
        return null;
    }

    public static final Map<String, Object> getParameterMap(HttpServletRequest request) {
        return WebUtils.getParametersStartingWith((ServletRequest)request, null);
    }

    public static final void setSession(Object key, Object value) {
        Session session;
        Subject currentUser = SecurityUtils.getSubject();
        if (null != currentUser && null != (session = currentUser.getSession())) {
            session.setAttribute(key, value);
        }
    }

    public static final Session getSession() {
        Subject subject = SecurityUtils.getSubject();
        if (null != subject) {
            return subject.getSession();
        }
        return null;
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-real-ip");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

