/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.cache;

import cn.yto.cache.LocalCacheObj;
import cn.yto.config.SystemConfig;
import cn.yto.entity.DeviceSortRecord;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.service.devicesort.DeviceSortRecordService;
import cn.yto.utils.ExpUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DeviceRecordCacheService {
    @Autowired
    private DeviceSortRecordService deviceSortRecordService;
    private SystemConfig systemConfig;
    public static LocalCacheObj<String, DeviceSortRecord> supplyRecordItemKeyCache;
    public static LocalCacheObj<String, DeviceSortRecord> waybillNoThreeCodeCache;
    public static LocalCacheObj<String, DeviceSortRecord> cartWaybillNoCache;
    public static ConcurrentHashMap<String, List<DeviceSortRecord>> supplyTableWaybillNoRecordCache;
    public static Map<String, Long> grayData;
    public static Map<String, String> threeCodeLattice;
    public static LocalCacheObj<String, Long> waybillNoScanTimeCache;
    public static LocalCacheObj<String, String> cartLastCache;
    private final ConcurrentHashMap<String, LinkedList<String>> cartScanQueueMap = new ConcurrentHashMap();
    public static Map<String, AtomicInteger> ipNoReadCache;
    public static Map<String, AtomicInteger> ipTotalCache;
    public static ConcurrentHashMap<String, String> packageWeightCache;
    private static final Logger logger;
    public static LocalCacheObj<String, Long> cartLastScanTime;

    private DeviceRecordCacheService(SystemConfig systemConfig) {
        this.systemConfig = systemConfig;
        supplyRecordItemKeyCache = new LocalCacheObj(systemConfig.getDeviceRecordCacheTime(), TimeUnit.MINUTES, systemConfig.getDeviceRecordCacheMaxNumber());
        waybillNoThreeCodeCache = new LocalCacheObj(systemConfig.getDeviceRecordCacheTime(), TimeUnit.MINUTES, systemConfig.getDeviceRecordCacheMaxNumber());
        cartWaybillNoCache = new LocalCacheObj(systemConfig.getDeviceRecordCacheTime(), TimeUnit.MINUTES, systemConfig.getDeviceRecordCacheMaxNumber());
        waybillNoScanTimeCache = new LocalCacheObj(systemConfig.getTopScanCacheTime(), TimeUnit.SECONDS, systemConfig.getDeviceRecordCacheMaxNumber());
        cartLastCache = new LocalCacheObj(systemConfig.getCartNoCacheTime(), TimeUnit.SECONDS, systemConfig.getDeviceRecordCacheMaxNumber());
        cartLastScanTime = new LocalCacheObj(2 * systemConfig.getMaxNoReadTime(), TimeUnit.MINUTES, systemConfig.getDeviceRecordCacheMaxNumber());
    }

    public DeviceSortRecord getDeviceRecordCacheByItemKey(String itemKey, String type) {
        if (ExpUtils.isBlank(itemKey)) {
            return null;
        }
        return supplyRecordItemKeyCache.get(itemKey, k -> this.deviceSortRecordService.searchDeviceSortByItemKey(itemKey, type));
    }

    public DeviceSortRecord getDeviceRecordCacheByWaybillNo(String waybillNo, String type) {
        if (ExpUtils.isBlank(waybillNo)) {
            return null;
        }
        return waybillNoThreeCodeCache.get(waybillNo, k -> this.deviceSortRecordService.searchDeviceSortByWaybillNo(waybillNo, type));
    }

    public void updateItemKeyCache(String itemKey, DeviceSortRecord deviceSortRecord) {
        if (ExpUtils.isBlank(itemKey)) {
            return;
        }
        supplyRecordItemKeyCache.put(itemKey, deviceSortRecord);
    }

    public void updateWaybillNoCache(String waybillNo, DeviceSortRecord deviceSortRecord) {
        if (ExpUtils.isBlank(waybillNo)) {
            return;
        }
        waybillNoThreeCodeCache.put(waybillNo, deviceSortRecord);
    }

    public void deleteItemKeyCache(String itemKey) {
        if (ExpUtils.isBlank(itemKey)) {
            return;
        }
        supplyRecordItemKeyCache.remove(itemKey);
    }

    public void deleteWaybillNoCache(String waybillNo) {
        if (ExpUtils.isBlank(waybillNo)) {
            return;
        }
        waybillNoThreeCodeCache.remove(waybillNo);
    }

    public List<DeviceSortRecord> initAndGetTableList(String devNo, String tableNo) {
        String tableKey = devNo.concat("_").concat(tableNo);
        return supplyTableWaybillNoRecordCache.computeIfAbsent(tableKey, key -> new ArrayList());
    }

    public DeviceSortRecord filterDeviceSort(String waybillNo, String seq, String devNo, String indNo) {
        List<DeviceSortRecord> records = this.initAndGetTableList(devNo, indNo);
        return records.stream().filter(e -> waybillNo.equals(e.getWaybillNo()) && seq.equals(e.getSeq()) && Objects.nonNull(e.getCameraTime())).max(Comparator.comparing(DeviceSortRecord::getCameraTime)).orElse(null);
    }

    public void updateCartWaybillNoCache(String waybillNo, DeviceSortRecord sortRecord) {
        String cartKey = sortRecord.getLayer().concat("_").concat(sortRecord.getCartNo()).concat("_").concat(waybillNo);
        cartWaybillNoCache.put(cartKey, sortRecord);
    }

    public DeviceSortRecord getDeviceSortByCartCache(String waybillNo, String devNo, String cartNo) {
        String cartKey = devNo.concat("_").concat(cartNo).concat("_").concat(waybillNo);
        return cartWaybillNoCache.get(cartKey);
    }

    public boolean exceedCircle(String cartNo, String ip, String waybillNo) {
        LinkedList<String> queue = this.cartScanQueueMap.get(cartNo);
        if (CollectionUtils.isEmpty(queue)) {
            queue = new LinkedList();
            queue.add(ip);
            logger.info("\u5185\u5b58\u961f\u5217\u4e3a\u7a7a,\u5355\u53f7{},\u5c0f\u8f66\u53f7:{},IP\uff1a{}", new Object[]{waybillNo, cartNo, ip});
            this.cartScanQueueMap.put(cartNo, queue);
            return false;
        }
        String queueCameraIp = queue.getFirst();
        logger.info("\u961f\u5217\u5927\u5c0f:{},\u961f\u5185\u76f8\u673aIP:{},\u5355\u53f7{},\u5c0f\u8f66\u53f7:{}", new Object[]{queue.size(), queueCameraIp, waybillNo, cartNo});
        if (queueCameraIp.equals(ip)) {
            logger.info("\u7b2c{}\u6b21\u7ecf\u8fc7\u76f8\u673a,\u5355\u53f7{},\u5c0f\u8f66\u53f7:{},IP\uff1a{}", new Object[]{queue.size(), waybillNo, cartNo, ip});
            queue.add(ip);
            this.cartScanQueueMap.put(cartNo, queue);
        }
        if (queue.size() > this.systemConfig.getCircle()) {
            logger.info("\u5355\u53f7{},\u5c0f\u8f66\u53f7:{},\u8d85\u51fa\u56de\u6d41\u5708\u6570:{},\u843d\u5f02\u5e38", new Object[]{waybillNo, cartNo, this.systemConfig.getCircle()});
            return true;
        }
        return false;
    }

    public void deleteCartNoCache(String cartNo) {
        LinkedList<String> queue = this.cartScanQueueMap.get(cartNo);
        if (!CollectionUtils.isEmpty(queue)) {
            queue.clear();
        }
    }

    public void incrementNoReadCount(String ip) {
        ipNoReadCache.computeIfAbsent(ip, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public void incrementTotalCount(String ip) {
        ipTotalCache.computeIfAbsent(ip, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public void deleteTableCache(String devNo, String tableNo) {
        String tableKey = devNo.concat("_").concat(tableNo);
        supplyTableWaybillNoRecordCache.remove(tableKey);
    }

    static {
        supplyTableWaybillNoRecordCache = new ConcurrentHashMap();
        grayData = new ConcurrentHashMap<String, Long>();
        threeCodeLattice = new ConcurrentHashMap<String, String>();
        ipNoReadCache = new ConcurrentHashMap<String, AtomicInteger>();
        ipTotalCache = new ConcurrentHashMap<String, AtomicInteger>();
        packageWeightCache = new ConcurrentHashMap();
        logger = CustomLoggerFactory.OperateLogger();
    }
}

