/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.cache;

import cn.yto.cache.OperationTableCacheService;
import cn.yto.config.IpMacConfiguration;
import cn.yto.config.IpTableNoConfiguration;
import cn.yto.entity.monitor.TExpOperationTable;
import cn.yto.utils.ExpUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IPMacService {
    private static final Logger logger = LoggerFactory.getLogger(IPMacService.class);
    @Autowired
    public IpTableNoConfiguration ipConfiguration;
    @Autowired
    private OperationTableCacheService operationTableCacheService;
    @Autowired
    private IpMacConfiguration ipMacConfiguration;
    public static Map<String, String> indNoIps = new HashMap<String, String>();
    public static Map<String, String> macIps = new HashMap<String, String>();

    public Map<String, String> initIndNoIpTables() {
        Map<String, String> mappings = this.ipConfiguration.getMappings();
        Set<Map.Entry<String, String>> entries = mappings.entrySet();
        for (Map.Entry<String, String> e : entries) {
            indNoIps.put(e.getValue(), e.getKey());
        }
        return indNoIps;
    }

    public String getIpByDevNoAndIndNo(String devNo, String indNo) {
        if (MapUtils.isEmpty(indNoIps)) {
            indNoIps = this.initIndNoIpTables();
        }
        return indNoIps.get(devNo + "," + indNo);
    }

    public String getMacByDevNoAndIndNo(String devNo, String indNo) {
        String ip = this.getIpByDevNoAndIndNo(devNo, indNo);
        if (ExpUtils.isBlank(ip)) {
            return null;
        }
        TExpOperationTable operationTableByIp = this.operationTableCacheService.getOperationTableByIp(ip);
        if (Objects.isNull(operationTableByIp)) {
            return null;
        }
        return operationTableByIp.getOperationMac();
    }

    public void initIpMacTables() {
        macIps = this.ipMacConfiguration.getMappings();
    }

    public String getMacByIp(String ip) {
        if (ExpUtils.isBlank(ip) || ExpUtils.isBlank(macIps.get(ip))) {
            logger.info("\u5f53\u524d\u7f13\u5b58\u4e2d\u65e0\u6b64\u76f8\u673aip:{}", (Object)ip);
            Set<Map.Entry<String, String>> entries = macIps.entrySet();
            Iterator<Map.Entry<String, String>> iterator = entries.iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, String> e = iterator.next();
                return e.getValue();
            }
            return "";
        }
        return macIps.get(ip);
    }
}

