/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.cache;

import cn.yto.cache.LocalCacheObj;
import cn.yto.entity.ExpLatticeBindEntity;
import cn.yto.service.lattice.LatticeBindService;
import cn.yto.utils.ExpUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LatticeBindCacheService {
    @Autowired
    private LatticeBindService latticeBindService;
    private static LocalCacheObj<String, ExpLatticeBindEntity> latticeBindCache = new LocalCacheObj(1000L);

    public ExpLatticeBindEntity getLatticeBindCacheByLatticeNo(String latticeNo) {
        if (ExpUtils.isBlank(latticeNo)) {
            return null;
        }
        return latticeBindCache.get(latticeNo, k -> this.latticeBindService.searchLatticeBindByLatticeNo(latticeNo));
    }

    public void updateLatticeBindCache(String latticeNo, ExpLatticeBindEntity expLatticeBindEntity) {
        if (ExpUtils.isBlank(latticeNo)) {
            return;
        }
        latticeBindCache.put(latticeNo, expLatticeBindEntity);
    }
}

