/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.cache;

import cn.yto.communication.business.send.SendOptSchemeComm;
import cn.yto.entity.busigateway.response.LatticeSchemeData;
import cn.yto.entity.busigateway.response.OptSchemeQueryData;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.ExpUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LatticeCacheService {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    public static LatticeSchemeData latticeSchemeData = null;
    @Autowired
    private SendOptSchemeComm latticeSchemeService;
    private static Long lastRefreshStartTime;

    public void refreshLatticeCache() {
        try {
            logger.info("\u5f00\u59cb\u5237\u65b0\u5f53\u524d\u683c\u53e3\u65b9\u6848");
            lastRefreshStartTime = System.currentTimeMillis();
            this.latticeSchemeService.reqBusinessGateway(null);
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0\u5f53\u524d\u683c\u53e3\u65b9\u6848\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void updateLatticeScheme(OptSchemeQueryData data) {
        if (data == null || CollectionUtils.isEmpty(data.getLatticeSchemeList()) || ExpUtils.isBlank(data.getSchemeId())) {
            logger.info("\u83b7\u53d6\u53ef\u7528\u683c\u53e3\u65b9\u6848\u4e3a\u7a7a \u4e0d\u8fdb\u884c\u5237\u65b0");
            return;
        }
        List latticeSchemeDatas = data.getLatticeSchemeList().stream().filter(s -> data.getSchemeId().equals(s.getSchemeId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(latticeSchemeDatas)) {
            logger.info("\u83b7\u53d6\u53ef\u7528\u683c\u53e3\u65b9\u6848\u4e3a\u7a7a \u4e0d\u8fdb\u884c\u5237\u65b0");
            return;
        }
        latticeSchemeData = (LatticeSchemeData)latticeSchemeDatas.get(0);
        logger.info("\u5237\u65b0\u5f53\u524d\u683c\u53e3\u65b9\u6848:{},\u8017\u65f6:{}", (Object)(latticeSchemeData == null ? "\u672a\u52a0\u8f7d\u5230" : latticeSchemeData.getInOutFlag()), (Object)(System.currentTimeMillis() - lastRefreshStartTime));
    }

    public static boolean currentSchemeExist() {
        return latticeSchemeData != null;
    }

    public static String getInOutFlag() {
        if (LatticeCacheService.currentSchemeExist()) {
            return latticeSchemeData.getInOutFlag();
        }
        return null;
    }

    public static String getEnableSchemeId() {
        if (LatticeCacheService.currentSchemeExist()) {
            return latticeSchemeData.getSchemeId();
        }
        return null;
    }
}

