/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class LocalCacheObj<K, V> {
    Cache<K, V> cache;

    public LocalCacheObj() {
        this.cache = Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(5L, TimeUnit.SECONDS).build();
    }

    public LocalCacheObj(long expireTime, TimeUnit timeUnit, long maximumSize) {
        this.cache = Caffeine.newBuilder().maximumSize(maximumSize).expireAfterWrite(expireTime, timeUnit).build();
    }

    public LocalCacheObj(long maximumSize) {
        this.cache = Caffeine.newBuilder().maximumSize(maximumSize).build();
    }

    public V get(String key) {
        return (V)this.cache.getIfPresent((Object)key);
    }

    public V get(K key, Function<K, V> function) {
        return (V)this.cache.get(key, function);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public void remove(String key) {
        this.cache.invalidate((Object)key);
    }

    public void removeAll() {
        this.cache.invalidateAll();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    public long size() {
        return this.cache.estimatedSize();
    }
}

