/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.cache;

import cn.yto.config.SortingConfig;
import cn.yto.config.WcsTcpServerConfig;
import cn.yto.entity.monitor.TExpAutoDevice;
import cn.yto.entity.monitor.TExpLattice;
import cn.yto.entity.monitor.TExpLatticeScheme;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.service.lattice.AutoDevicesService;
import cn.yto.service.lattice.LatticeSchemeService;
import cn.yto.service.lattice.LatticeService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewLatticeCacheService {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    public static TExpAutoDevice currentAutoDevice = null;
    public static TExpLatticeScheme currentScheme = null;
    public static String currentSchemeInOutFlag = null;
    public static Map<String, TExpLatticeScheme> latticeSchemeMap = new ConcurrentHashMap<String, TExpLatticeScheme>();
    public static Map<String, List<TExpLattice>> latticeMap = new ConcurrentHashMap<String, List<TExpLattice>>();
    @Autowired
    private AutoDevicesService autoDevicesService;
    @Autowired
    private LatticeSchemeService latticeSchemeService;
    @Autowired
    private LatticeService latticeService;
    @Autowired
    WcsTcpServerConfig wcsTcpServerConfig;
    @Autowired
    private SortingConfig sortingConfig;

    public void refresh() {
        long start;
        try {
            start = System.currentTimeMillis();
            this.autoDevicesService.refreshCurrentAutoDevice();
            logger.info("\u5237\u65b0\u5f53\u524d\u5206\u62e3\u8bbe\u5907:{},\u8017\u65f6:{}", (Object)(currentAutoDevice == null ? "\u672a\u52a0\u8f7d\u5230" + this.wcsTcpServerConfig.getWcsIp() + ":" + this.wcsTcpServerConfig.getWcsTcpPort() : currentAutoDevice.getWcsIp() + ":" + currentAutoDevice.getWcsPort()), (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0\u5f53\u524d\u5206\u62e3\u8bbe\u5907\u5f02\u5e38", (Throwable)e);
        }
        try {
            start = System.currentTimeMillis();
            this.latticeSchemeService.refreshCurrentScheme();
            String inOutFlagDesc = TExpLatticeScheme.getInOutFlagDesc(currentSchemeInOutFlag);
            logger.info("\u5237\u65b0\u5f53\u524d\u683c\u53e3\u65b9\u6848:{},\u8017\u65f6:{}", (Object)(currentScheme == null ? "\u672a\u52a0\u8f7d\u5230" : currentScheme.getSchemeNo() + "-" + inOutFlagDesc), (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0\u5f53\u524d\u683c\u53e3\u65b9\u6848\u5f02\u5e38", (Throwable)e);
        }
        try {
            long start2 = System.currentTimeMillis();
            this.latticeService.refreshLattices();
            logger.info("\u5237\u65b0\u683c\u53e3\u660e\u7ec6\u5b8c\u6210,\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start2));
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0\u5f53\u524d\u683c\u53e3\u65b9\u6848\u660e\u7ec6\u5f02\u5e38", (Throwable)e);
        }
    }

    public static boolean isOut() {
        boolean result = false;
        String currentSchemeInOutFlag = NewLatticeCacheService.currentSchemeInOutFlag;
        if ("2".equals(currentSchemeInOutFlag)) {
            result = true;
        } else if ("1".equals(currentSchemeInOutFlag)) {
            result = false;
        }
        return result;
    }

    public static boolean isIn() {
        boolean result = false;
        String currentSchemeInOutFlag = NewLatticeCacheService.currentSchemeInOutFlag;
        if ("1".equals(currentSchemeInOutFlag)) {
            result = true;
        } else if ("2".equals(currentSchemeInOutFlag)) {
            result = false;
        }
        return result;
    }

    public String getLatticeNoByDestOrgCode(String deviceId, String destOrgCode) {
        List<TExpLattice> tExpLattices = latticeMap.get(deviceId);
        return tExpLattices.stream().filter(e -> destOrgCode.equals(e.getDestOrgCode())).map(TExpLattice::getLatticeNo).distinct().collect(Collectors.joining(","));
    }

    public boolean enableLatticeRound() {
        if ("0".equals(this.sortingConfig.getRoundLattice())) {
            return false;
        }
        if ("3".equals(this.sortingConfig.getRoundLattice())) {
            return true;
        }
        return this.sortingConfig.getRoundLattice().equals(currentSchemeInOutFlag);
    }
}

